/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.GuideSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class EnhancedGuideSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.EnhancedGuideSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public EnhancedGuideSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.17", "EnhancedGuide");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.18", "EnhancedGuide");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.19", "EnhancedGuide");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "EnhancedGuide";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.21";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Enhanced Guide";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = StaticUtils.toLowerCase(byteString.stringValue());
        int n = string.indexOf(35);
        if (n < 0) {
            int n2 = 6488277;
            stringBuilder.append(MessageHandler.getMessage(n2, string));
            return false;
        }
        String string2 = string.substring(0, n).trim();
        int n3 = string2.length();
        if (n3 == 0) {
            int n4 = 6488278;
            stringBuilder.append(MessageHandler.getMessage(n4, string));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(string2, 0, n3, stringBuilder)) {
            return false;
        }
        int n5 = string.lastIndexOf(35);
        if (n5 == n) {
            int n6 = 6488282;
            stringBuilder.append(MessageHandler.getMessage(n6, string));
            return false;
        }
        String string3 = string.substring(n5 + 1).trim();
        if (!(string3.equals("baseobject") || string3.equals("onelevel") || string3.equals("wholesubtree") || string3.equals("subordinatesubtree"))) {
            if (string3.length() == 0) {
                int n7 = 6488283;
                stringBuilder.append(MessageHandler.getMessage(n7, string));
            } else {
                int n8 = 6488284;
                stringBuilder.append(MessageHandler.getMessage(n8, string, string3));
            }
            return false;
        }
        String string4 = string.substring(n + 1, n5).trim();
        int n9 = string4.length();
        if (n9 == 0) {
            int n10 = 6488285;
            stringBuilder.append(MessageHandler.getMessage(n10, string));
            return false;
        }
        return GuideSyntax.criteriaIsValid(string4, string, stringBuilder);
    }
}

