/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.HashSet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class TeletexTerminalIdentifierSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.TeletexTerminalIdentifierSyntax";
    public static final HashSet<String> ALLOWED_TTX_PARAMETERS = new HashSet(5);
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public TeletexTerminalIdentifierSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "TeletexTerminalIdentifier");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "TeletexTerminalIdentifier");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "TeletexTerminalIdentifier");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "TeletexTerminalIdentifier";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.51";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Teletex Terminal Identifier";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        String string;
        int n;
        String string2;
        int n2;
        int n3;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string3 = byteString.stringValue();
        int n4 = string3.length();
        if (n4 == 0) {
            int n5 = 6488259;
            stringBuilder.append(MessageHandler.getMessage(n5));
            return false;
        }
        char c = string3.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            int n6 = 6488260;
            stringBuilder.append(MessageHandler.getMessage(n6, string3, Character.valueOf(c), 0));
            return false;
        }
        for (n3 = 1; n3 < n4; ++n3) {
            c = string3.charAt(n3);
            if (c == '$') {
                ++n3;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            n2 = 6488260;
            stringBuilder.append(MessageHandler.getMessage(n2, string3, Character.valueOf(c), n3));
        }
        if (n3 >= n4) {
            if (c == '$') {
                n2 = 6488261;
                stringBuilder.append(MessageHandler.getMessage(n2, string3));
                return false;
            }
            return true;
        }
        n2 = n3;
        boolean bl = false;
        while (n3 < n4) {
            if (bl) {
                ++n3;
                continue;
            }
            if ((c = string3.charAt(n3++)) == '\\') {
                bl = true;
                continue;
            }
            if (c != '$') continue;
            string2 = string3.substring(n2, n3);
            n = string2.indexOf(58);
            if (n < 0) {
                int n7 = 6488262;
                stringBuilder.append(MessageHandler.getMessage(n7, string3, string2, n2));
                return false;
            }
            string = string2.substring(0, n);
            if (!ALLOWED_TTX_PARAMETERS.contains(string)) {
                int n8 = 6488263;
                stringBuilder.append(MessageHandler.getMessage(n8, string3, string));
                return false;
            }
            n2 = n3;
        }
        string2 = string3.substring(n2);
        n = string2.indexOf(58);
        if (n < 0) {
            int n9 = 6488262;
            stringBuilder.append(MessageHandler.getMessage(n9, string3, string2, n2));
            return false;
        }
        string = string2.substring(0, n);
        if (!ALLOWED_TTX_PARAMETERS.contains(string)) {
            int n10 = 6488263;
            stringBuilder.append(MessageHandler.getMessage(n10, string3, string));
            return false;
        }
        return true;
    }

    static {
        ALLOWED_TTX_PARAMETERS.add("graphic");
        ALLOWED_TTX_PARAMETERS.add("control");
        ALLOWED_TTX_PARAMETERS.add("misc");
        ALLOWED_TTX_PARAMETERS.add("page");
        ALLOWED_TTX_PARAMETERS.add("private");
    }
}

