/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class UTCTimeSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.UTCTimeSyntax";
    private static ReentrantLock dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public UTCTimeSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.27");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.27", "UTCTime");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.28");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.28", "UTCTime");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "UTCTime");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "UTCTime";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.53";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "UTC Time";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue().toUpperCase();
        int n = string.length();
        if (n < 13) {
            int n2 = 6488173;
            String string2 = MessageHandler.getMessage(n2, string);
            stringBuilder.append(string2);
            return false;
        }
        block56: for (c = '\u0000'; c < '\u0004'; ++c) {
            switch (string.charAt(c)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block56;
                }
                default: {
                    int n3 = 6488174;
                    String string3 = MessageHandler.getMessage(n3, string, Character.valueOf(string.charAt(c)));
                    stringBuilder.append(string3);
                    return false;
                }
            }
        }
        c = string.charAt(4);
        char c2 = string.charAt(5);
        block3 : switch (c) {
            case '0': {
                switch (c2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                int n4 = 6488175;
                String string4 = MessageHandler.getMessage(n4, string, string.substring(4, 6));
                stringBuilder.append(string4);
                return false;
            }
            case '1': {
                switch (c2) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break block3;
                    }
                }
                int n5 = 6488175;
                String string5 = MessageHandler.getMessage(n5, string, string.substring(4, 6));
                stringBuilder.append(string5);
                return false;
            }
            default: {
                int n6 = 6488175;
                String string6 = MessageHandler.getMessage(n6, string, string.substring(4, 6));
                stringBuilder.append(string6);
                return false;
            }
        }
        char c3 = string.charAt(6);
        char c4 = string.charAt(7);
        block13 : switch (c3) {
            case '0': {
                switch (c4) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                int n7 = 6488176;
                String string7 = MessageHandler.getMessage(n7, string, string.substring(6, 8));
                stringBuilder.append(string7);
                return false;
            }
            case '1': 
            case '2': {
                switch (c4) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                int n8 = 6488176;
                String string8 = MessageHandler.getMessage(n8, string, string.substring(6, 8));
                stringBuilder.append(string8);
                return false;
            }
            case '3': {
                switch (c4) {
                    case '0': 
                    case '1': {
                        break block13;
                    }
                }
                int n9 = 6488176;
                String string9 = MessageHandler.getMessage(n9, string, string.substring(6, 8));
                stringBuilder.append(string9);
                return false;
            }
            default: {
                int n10 = 6488176;
                String string10 = MessageHandler.getMessage(n10, string, string.substring(6, 8));
                stringBuilder.append(string10);
                return false;
            }
        }
        char c5 = string.charAt(8);
        char c6 = string.charAt(9);
        block27 : switch (c5) {
            case '0': 
            case '1': {
                switch (c6) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block27;
                    }
                }
                int n11 = 6488177;
                String string11 = MessageHandler.getMessage(n11, string, string.substring(8, 10));
                stringBuilder.append(string11);
                return false;
            }
            case '2': {
                switch (c6) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block27;
                    }
                }
                int n12 = 6488177;
                String string12 = MessageHandler.getMessage(n12, string, string.substring(8, 10));
                stringBuilder.append(string12);
                return false;
            }
            default: {
                int n13 = 6488177;
                String string13 = MessageHandler.getMessage(n13, string, string.substring(8, 10));
                stringBuilder.append(string13);
                return false;
            }
        }
        c = string.charAt(10);
        block37 : switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (n < 13) {
                    int n14 = 6488179;
                    String string14 = MessageHandler.getMessage(n14, string, Character.valueOf(c), 10);
                    stringBuilder.append(string14);
                    return false;
                }
                switch (string.charAt(11)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block37;
                    }
                }
                int n15 = 6488178;
                String string15 = MessageHandler.getMessage(n15, string, string.substring(10, 12));
                stringBuilder.append(string15);
                return false;
            }
            default: {
                int n16 = 6488179;
                String string16 = MessageHandler.getMessage(n16, string, Character.valueOf(c), 10);
                stringBuilder.append(string16);
                return false;
            }
        }
        char c7 = string.charAt(12);
        block43 : switch (c7) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (n < 15) {
                    int n17 = 6488179;
                    String string17 = MessageHandler.getMessage(n17, string, Character.valueOf(c7), 12);
                    stringBuilder.append(string17);
                    return false;
                }
                switch (string.charAt(13)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block43;
                    }
                }
                int n18 = 6488180;
                String string18 = MessageHandler.getMessage(n18, string, string.substring(12, 14));
                stringBuilder.append(string18);
                return false;
            }
            case '6': {
                if (n < 15) {
                    int n19 = 6488179;
                    String string19 = MessageHandler.getMessage(n19, string, Character.valueOf(c7), 12);
                    stringBuilder.append(string19);
                    return false;
                }
                if (string.charAt(13) == '0') break;
                int n20 = 6488180;
                String string20 = MessageHandler.getMessage(n20, string, string.substring(12, 14));
                stringBuilder.append(string20);
                return false;
            }
            case 'Z': {
                if (n == 13) {
                    return true;
                }
                int n21 = 6488179;
                String string21 = MessageHandler.getMessage(n21, string, Character.valueOf(c7), 12);
                stringBuilder.append(string21);
                return false;
            }
            case '+': 
            case '-': {
                if (n == 17) {
                    return this.hasValidOffset(string, 13, stringBuilder);
                }
                int n22 = 6488179;
                String string22 = MessageHandler.getMessage(n22, string, Character.valueOf(c7), 12);
                stringBuilder.append(string22);
                return false;
            }
            default: {
                int n23 = 6488179;
                String string23 = MessageHandler.getMessage(n23, string, Character.valueOf(c7), 12);
                stringBuilder.append(string23);
                return false;
            }
        }
        switch (string.charAt(14)) {
            case 'Z': {
                if (n == 15) {
                    return true;
                }
                int n24 = 6488179;
                String string24 = MessageHandler.getMessage(n24, string, Character.valueOf(string.charAt(14)), 14);
                stringBuilder.append(string24);
                return false;
            }
            case '+': 
            case '-': {
                if (n == 19 || n == 17) {
                    return this.hasValidOffset(string, 15, stringBuilder);
                }
                int n25 = 6488179;
                String string25 = MessageHandler.getMessage(n25, string, Character.valueOf(string.charAt(14)), 14);
                stringBuilder.append(string25);
                return false;
            }
        }
        int n26 = 6488179;
        String string26 = MessageHandler.getMessage(n26, string, Character.valueOf(string.charAt(14)), 14);
        stringBuilder.append(string26);
        return false;
    }

    private boolean hasValidOffset(String string, int n, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "hasValidOffset", String.valueOf(string), String.valueOf(n), "java.lang.StringBuilder"));
        int n2 = string.length() - n;
        if (n2 < 2) {
            int n3 = 6488173;
            String string2 = MessageHandler.getMessage(n3, string);
            stringBuilder.append(string2);
            return false;
        }
        block0 : switch (string.charAt(n)) {
            case '0': 
            case '1': {
                switch (string.charAt(n + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block0;
                    }
                }
                int n4 = 6488181;
                String string3 = MessageHandler.getMessage(n4, string, string.substring(n, n + n2));
                stringBuilder.append(string3);
                return false;
            }
            case '2': {
                switch (string.charAt(n + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block0;
                    }
                }
                int n5 = 6488181;
                String string4 = MessageHandler.getMessage(n5, string, string.substring(n, n + n2));
                stringBuilder.append(string4);
                return false;
            }
            default: {
                int n6 = 6488181;
                String string5 = MessageHandler.getMessage(n6, string, string.substring(n, n + n2));
                stringBuilder.append(string5);
                return false;
            }
        }
        if (n2 == 4) {
            block10 : switch (string.charAt(n + 2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (string.charAt(n + 3)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block10;
                        }
                    }
                    int n7 = 6488181;
                    String string6 = MessageHandler.getMessage(n7, string, string.substring(n, n + n2));
                    stringBuilder.append(string6);
                    return false;
                }
                default: {
                    int n8 = 6488181;
                    String string7 = MessageHandler.getMessage(n8, string, string.substring(n, n + n2));
                    stringBuilder.append(string7);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValue createUTCTimeValue(Date date) {
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "createUTCTimeValue", String.valueOf(date)));
        dateFormatLock.lock();
        try {
            string = dateFormat.format(date);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createUTCTimevalue", exception));
            string = null;
        }
        finally {
            dateFormatLock.unlock();
        }
        return new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date decodeUTCTimeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeUTCTimeValue", String.valueOf(byteString)));
        String string = byteString.stringValue();
        try {
            dateFormatLock.lock();
            try {
                Date date = dateFormat.parse(string);
                return date;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeUTCTimeValue", exception));
            int n = 6488182;
            String string2 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n, exception);
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormatLock = new ReentrantLock();
    }
}

