/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class UUIDSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.UUIDSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;

    public UUIDSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.1.16.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "1.3.6.1.1.16.2", "UUID");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("1.3.6.1.1.16.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "1.3.6.1.1.16.3", "UUID");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "UUID";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.1.16.1";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "UUID";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return null;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue();
        if (string.length() != 36) {
            int n = 6422764;
            stringBuilder.append(MessageHandler.getMessage(n, string, string.length()));
            return false;
        }
        block6: for (int i = 0; i < 36; ++i) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (string.charAt(i) == '-') continue block6;
                    int n = 6422765;
                    stringBuilder.append(MessageHandler.getMessage(n, string, i, Character.valueOf(string.charAt(i))));
                    return false;
                }
                default: {
                    switch (string.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            continue block6;
                        }
                    }
                    int n = 6422766;
                    stringBuilder.append(MessageHandler.getMessage(n, string, i, Character.valueOf(string.charAt(i))));
                    return false;
                }
            }
        }
        return true;
    }
}

