/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteString;

public class UserPasswordExactEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.UserPasswordExactEqualityMatchingRule";

    public UserPasswordExactEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "ds-mr-user-password-exact";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.4.2";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "user password exact matching rule";
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        byte[] byArray = byteString.value();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (!UserPasswordSyntax.isEncoded(byteString)) return new ASN1OctetString(byArray2);
        int n = 1;
        while (n < byArray2.length) {
            switch (byArray2[n]) {
                case 65: {
                    byArray2[n] = 97;
                    break;
                }
                case 66: {
                    byArray2[n] = 98;
                    break;
                }
                case 67: {
                    byArray2[n] = 99;
                    break;
                }
                case 68: {
                    byArray2[n] = 100;
                    break;
                }
                case 69: {
                    byArray2[n] = 101;
                    break;
                }
                case 70: {
                    byArray2[n] = 102;
                    break;
                }
                case 71: {
                    byArray2[n] = 103;
                    break;
                }
                case 72: {
                    byArray2[n] = 104;
                    break;
                }
                case 73: {
                    byArray2[n] = 105;
                    break;
                }
                case 74: {
                    byArray2[n] = 106;
                    break;
                }
                case 75: {
                    byArray2[n] = 107;
                    break;
                }
                case 76: {
                    byArray2[n] = 108;
                    break;
                }
                case 77: {
                    byArray2[n] = 109;
                    break;
                }
                case 78: {
                    byArray2[n] = 110;
                    break;
                }
                case 79: {
                    byArray2[n] = 111;
                    break;
                }
                case 80: {
                    byArray2[n] = 112;
                    break;
                }
                case 81: {
                    byArray2[n] = 113;
                    break;
                }
                case 82: {
                    byArray2[n] = 114;
                    break;
                }
                case 83: {
                    byArray2[n] = 115;
                    break;
                }
                case 84: {
                    byArray2[n] = 116;
                    break;
                }
                case 85: {
                    byArray2[n] = 117;
                    break;
                }
                case 86: {
                    byArray2[n] = 118;
                    break;
                }
                case 87: {
                    byArray2[n] = 119;
                    break;
                }
                case 88: {
                    byArray2[n] = 120;
                    break;
                }
                case 89: {
                    byArray2[n] = 121;
                    break;
                }
                case 90: {
                    byArray2[n] = 122;
                    break;
                }
                case 125: {
                    return new ASN1OctetString(byArray2);
                }
            }
            ++n;
        }
        return new ASN1OctetString(byArray2);
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

