/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.opends.server.changelog.ProtocolSession;
import org.opends.server.changelog.SocketSession;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.ChangelogStartMessage;
import org.opends.server.synchronization.FakeOperation;
import org.opends.server.synchronization.FakeOperationComparator;
import org.opends.server.synchronization.Historical;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelogBroker
implements InternalSearchListener {
    private boolean shutdown = false;
    private List<String> servers;
    private Short identifier;
    private boolean connected = false;
    private SynchronizationDomain domain;
    private final Object lock = new Object();
    private String changelogServer = "Not connected";
    private TreeSet<FakeOperation> replayOperations;
    private ProtocolSession session = null;

    public ChangelogBroker(SynchronizationDomain synchronizationDomain) {
        this.domain = synchronizationDomain;
        this.replayOperations = new TreeSet<FakeOperation>(new FakeOperationComparator());
    }

    public void start(Short s, List<String> list) throws Exception {
        this.identifier = s;
        this.servers = list;
        if (list.size() < 1) {
            int n = 17235987;
            String string = MessageHandler.getMessage(n);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws NumberFormatException, IOException {
        boolean bl = true;
        while (!this.connected) {
            Object object;
            for (String string : this.servers) {
                Object object2;
                object = string.split(":");
                String string2 = object[0];
                String string3 = object[1];
                try {
                    Object object3;
                    ChangeNumber changeNumber;
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string2), Integer.parseInt(string3));
                    Socket socket = new Socket();
                    socket.connect(inetSocketAddress, 500);
                    this.session = new SocketSession(socket);
                    object2 = this.domain.newServerStartMessage();
                    this.session.publish((SynchronizationMessage)object2);
                    ChangelogStartMessage changelogStartMessage = (ChangelogStartMessage)this.session.receive();
                    ChangeNumber changeNumber2 = changelogStartMessage.getServerState().getMaxChangeNumber(this.identifier);
                    if (changeNumber2 == null) {
                        changeNumber2 = new ChangeNumber(0L, 0, this.identifier);
                    }
                    if ((changeNumber = this.domain.getMaxChangeNumber()) == null || changeNumber.olderOrEqual(changeNumber2).booleanValue()) {
                        this.changelogServer = inetSocketAddress.toString();
                        this.connected = true;
                        break;
                    }
                    if (bl) {
                        int n = 17235986;
                        object3 = MessageHandler.getMessage(n, string);
                        Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, (String)object3, n);
                        continue;
                    }
                    this.replayOperations.clear();
                    InternalClientConnection internalClientConnection = new InternalClientConnection();
                    object3 = LDAPFilter.decode("(ds-sync-hist>=dummy:" + changeNumber2 + ")");
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(1);
                    linkedHashSet.add("ds-sync-hist");
                    InternalSearchOperation internalSearchOperation = internalClientConnection.processSearch(new ASN1OctetString(this.domain.getBaseDN().toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, (LDAPFilter)object3, linkedHashSet, (InternalSearchListener)this);
                    if (internalSearchOperation.getResultCode() != ResultCode.SUCCESS) {
                        int n = 17235989;
                        String string4 = MessageHandler.getMessage(n);
                        Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.FATAL_ERROR, string4, n);
                        continue;
                    }
                    this.changelogServer = inetSocketAddress.toString();
                    this.connected = true;
                    for (FakeOperation fakeOperation : this.replayOperations) {
                        this.publish(fakeOperation.generateMessage());
                    }
                    break;
                }
                catch (ConnectException connectException) {
                    int n = 0x1070011;
                    object2 = MessageHandler.getMessage(n, string);
                    Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, (String)object2, n);
                }
                catch (Exception exception) {
                    int n = 17235988;
                    object2 = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(exception);
                    Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n);
                }
                finally {
                    if (this.connected || this.session == null) continue;
                    this.session.close();
                    this.session = null;
                }
            }
            if (this.connected) continue;
            if (bl) {
                bl = false;
                int n = 17235990;
                String string = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
                continue;
            }
            ChangelogBroker changelogBroker = this;
            synchronized (changelogBroker) {
                bl = false;
                int n = 0x1070017;
                object = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, (String)object, n);
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void reStart(ProtocolSession protocolSession) {
        try {
            protocolSession.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (protocolSession == this.session) {
            this.connected = false;
        }
        while (!this.connected && !this.shutdown) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                int n = 17235988;
                String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(exception);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(SynchronizationMessage synchronizationMessage) {
        boolean bl = false;
        ProtocolSession protocolSession = this.session;
        while (!bl) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (!this.connected) {
                        this.reStart(protocolSession);
                    }
                    this.session.publish(synchronizationMessage);
                    bl = true;
                }
                catch (IOException iOException) {
                    this.reStart(protocolSession);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationMessage receive() {
        while (!this.shutdown) {
            ProtocolSession protocolSession = this.session;
            try {
                return this.session.receive();
            }
            catch (Exception exception) {
                if (this.shutdown) continue;
                Object object = this.lock;
                synchronized (object) {
                    this.reStart(protocolSession);
                }
            }
        }
        return null;
    }

    public void stop() {
        this.shutdown = true;
        try {
            this.session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void restartReceive() throws Exception {
    }

    public void suspendReceive() throws Exception {
    }

    public String getChangelogServer() {
        return this.changelogServer;
    }

    @Override
    public void handleInternalSearchEntry(InternalSearchOperation internalSearchOperation, SearchResultEntry searchResultEntry) {
        Iterable<FakeOperation> iterable = Historical.generateFakeOperations(searchResultEntry);
        for (FakeOperation fakeOperation : iterable) {
            this.replayOperations.add(fakeOperation);
        }
    }

    @Override
    public void handleInternalSearchReference(InternalSearchOperation internalSearchOperation, SearchResultReference searchResultReference) {
    }
}

