/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.core.DirectoryException;
import org.opends.server.synchronization.ServerState;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.DN;

public class ChangelogStartMessage
extends SynchronizationMessage
implements Serializable {
    private static final long serialVersionUID = -5871385537169856856L;
    private String baseDn = null;
    private short serverId;
    private String serverURL;
    private ServerState serverState;

    public ChangelogStartMessage(short s, String string, DN dN, ServerState serverState) {
        this.serverId = s;
        this.serverURL = string;
        this.baseDn = dN != null ? dN.toNormalizedString() : null;
        this.serverState = serverState;
    }

    public ChangelogStartMessage(byte[] byArray) throws DataFormatException {
        try {
            if (byArray[0] != 7) {
                throw new DataFormatException("input is not a valid ChangelogStartMsg");
            }
            int n = 1;
            int n2 = this.getNextLength(byArray, n);
            this.baseDn = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            String string = new String(byArray, n, n2, "UTF-8");
            this.serverId = Short.valueOf(string);
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.serverURL = new String(byArray, n, n2, "UTF-8");
            this.serverState = new ServerState(byArray, n += n2 + 1, byArray.length - 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public DN getBaseDn() {
        if (this.baseDn == null) {
            return null;
        }
        try {
            return DN.decode(this.baseDn);
        }
        catch (DirectoryException directoryException) {
            return null;
        }
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public UpdateMessage processReceive(SynchronizationDomain synchronizationDomain) {
        return null;
    }

    public byte[] getBytes() {
        try {
            byte[] byArray = this.baseDn.getBytes("UTF-8");
            byte[] byArray2 = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byArray3 = this.serverURL.getBytes("UTF-8");
            byte[] byArray4 = this.serverState.getBytes();
            int n = 1 + byArray.length + 1 + byArray2.length + 1 + byArray3.length + 1 + byArray4.length + 1;
            byte[] byArray5 = new byte[n];
            byArray5[0] = 7;
            int n2 = 1;
            n2 = this.addByteArray(byArray, byArray5, n2);
            n2 = this.addByteArray(byArray2, byArray5, n2);
            n2 = this.addByteArray(byArray3, byArray5, n2);
            n2 = this.addByteArray(byArray4, byArray5, n2);
            return byArray5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

