/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.server.core.DirectoryServer;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.HistKey;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistVal {
    private AttributeType attrType;
    private String attrString;
    private AttributeValue attributeValue;
    private ChangeNumber cn;
    private Set<String> options = null;
    private HistKey histKey;
    private String stringValue;

    public HistVal(String string) {
        String[] stringArray = string.split(":", 4);
        if (stringArray[0].contains(";")) {
            String[] stringArray2 = stringArray[0].split(";");
            this.options = new HashSet<String>();
            int n = 1;
            while (stringArray2[n] != null) {
                this.options.add(stringArray2[n]);
                ++n;
            }
            this.attrString = stringArray2[0];
        } else {
            this.attrString = stringArray[0];
        }
        this.attrType = DirectoryServer.getSchema().getAttributeType(this.attrString);
        this.cn = new ChangeNumber(stringArray[1]);
        this.histKey = HistKey.decodeKey(stringArray[2]);
        this.stringValue = null;
        if (this.histKey != HistKey.DELATTR) {
            this.stringValue = stringArray[3];
            this.attributeValue = new AttributeValue(this.attrType, this.stringValue);
        } else {
            this.stringValue = null;
            this.attributeValue = null;
        }
    }

    public String getAttrString() {
        return this.attrString;
    }

    public AttributeType getAttrType() {
        return this.attrType;
    }

    public ChangeNumber getCn() {
        return this.cn;
    }

    public HistKey getHistKey() {
        return this.histKey;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public AttributeValue getAttributeValue() {
        return this.attributeValue;
    }

    public Modification generateMod() {
        Modification modification;
        Attribute attribute = new Attribute(this.attrType);
        if (this.histKey != HistKey.DELATTR) {
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            linkedHashSet.add(this.attributeValue);
            attribute.setValues(linkedHashSet);
        }
        switch (this.histKey) {
            case ADD: {
                modification = new Modification(ModificationType.ADD, attribute);
                break;
            }
            case DEL: {
                modification = new Modification(ModificationType.DELETE, attribute);
                break;
            }
            case REPL: {
                modification = new Modification(ModificationType.REPLACE, attribute);
                break;
            }
            case DELATTR: {
                modification = new Modification(ModificationType.DELETE, attribute);
                break;
            }
            default: {
                modification = null;
            }
        }
        return modification;
    }
}

