/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogger;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.ConfigFileHandler;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.Error;
import org.opends.server.loggers.StartupErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackUpDB {
    public static void main(String[] stringArray) {
        int n = BackUpDB.mainBackUpDB(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainBackUpDB(String[] stringArray) {
        boolean bl;
        int n;
        Object object2;
        Object object3;
        String string;
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        BooleanArgument booleanArgument4 = null;
        BooleanArgument booleanArgument5 = null;
        BooleanArgument booleanArgument6 = null;
        BooleanArgument booleanArgument7 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        StringArgument stringArgument5 = null;
        StringArgument stringArgument6 = null;
        ArgumentParser argumentParser = new ArgumentParser("org.opends.server.tools.BackUpDB", false);
        try {
            stringArgument3 = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10486003, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            stringArgument4 = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 10486004, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            stringArgument = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, true, true, "{backendID}", null, null, 10486005, new Object[0]);
            argumentParser.addArgument(stringArgument);
            booleanArgument = new BooleanArgument("backupall", Character.valueOf('a'), "backUpAll", 10486034, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            stringArgument2 = new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, "{backupID}", null, null, 10486006, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument5 = new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, "{backupDir}", null, null, 10486007, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            booleanArgument6 = new BooleanArgument("incremental", Character.valueOf('i'), "incremental", 10486008, new Object[0]);
            argumentParser.addArgument(booleanArgument6);
            stringArgument6 = new StringArgument("incrementalbaseid", Character.valueOf('B'), "incrementalBaseID", false, false, true, "{backupID}", null, null, 10486047, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            booleanArgument2 = new BooleanArgument("compress", Character.valueOf('c'), "compress", 10486009, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            booleanArgument4 = new BooleanArgument("encrypt", Character.valueOf('y'), "encrypt", 0xA000FA, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            booleanArgument5 = new BooleanArgument("hash", Character.valueOf('h'), "hash", 10486011, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            booleanArgument7 = new BooleanArgument("signhash", Character.valueOf('s'), "signHash", 10486012, new Object[0]);
            argumentParser.addArgument(booleanArgument7);
            booleanArgument3 = new BooleanArgument("help", Character.valueOf('H'), "help", 10486013, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            argumentParser.setUsageArgument(booleanArgument3);
        }
        catch (ArgumentException argumentException) {
            int n2 = 10748158;
            String string2 = MessageHandler.getMessage(n2, argumentException.getMessage());
            System.err.println(string2);
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n3 = 10748159;
            String string3 = MessageHandler.getMessage(n3, argumentException.getMessage());
            System.err.println(string3);
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument3.isPresent()) {
            return 0;
        }
        if (booleanArgument.isPresent()) {
            if (stringArgument.isPresent()) {
                int n4 = 10748179;
                String string4 = MessageHandler.getMessage(n4, booleanArgument.getLongIdentifier(), stringArgument.getLongIdentifier());
                System.err.println(string4);
                return 1;
            }
        } else if (!stringArgument.isPresent()) {
            int n5 = 10748180;
            String string5 = MessageHandler.getMessage(n5, booleanArgument.getLongIdentifier(), stringArgument.getLongIdentifier());
            System.err.println(string5);
            return 1;
        }
        if (stringArgument2.isPresent()) {
            string = stringArgument2.getValue();
        } else {
            object3 = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            ((DateFormat)object3).setTimeZone(TimeZone.getTimeZone("UTC"));
            string = ((DateFormat)object3).format(new Date());
        }
        if (stringArgument6.isPresent()) {
            if (!booleanArgument6.isPresent()) {
                int n6 = 10748192;
                String string6 = MessageHandler.getMessage(n6, stringArgument6.getLongIdentifier(), booleanArgument6.getLongIdentifier());
                System.err.println(string6);
                return 1;
            }
            object3 = stringArgument6.getValue();
        } else {
            object3 = null;
        }
        if (booleanArgument7.isPresent() && !booleanArgument5.isPresent()) {
            int n7 = 10748230;
            String string7 = MessageHandler.getMessage(n7, booleanArgument7.getLongIdentifier(), booleanArgument5.getLongIdentifier());
            System.err.println(string7);
            return 1;
        }
        File file = new File(stringArgument5.getValue());
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                int n8 = 10748181;
                String string8 = MessageHandler.getMessage(n8, stringArgument5.getValue(), StaticUtils.stackTraceToSingleLineString(exception));
                System.err.println(string8);
                return 1;
            }
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        try {
            directoryServer.bootstrapClient();
            directoryServer.initializeJMX();
        }
        catch (Exception exception) {
            int n9 = 10748160;
            String string9 = MessageHandler.getMessage(n9, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string9);
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(stringArgument3.getValue(), stringArgument4.getValue());
        }
        catch (InitializationException initializationException) {
            int n10 = 10748161;
            String string10 = MessageHandler.getMessage(n10, initializationException.getMessage());
            System.err.println(string10);
            return 1;
        }
        catch (Exception exception) {
            int n11 = 10748161;
            String string11 = MessageHandler.getMessage(n11, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string11);
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (ConfigException configException) {
            int n12 = 10748162;
            String string12 = MessageHandler.getMessage(n12, configException.getMessage());
            System.err.println(string12);
            return 1;
        }
        catch (InitializationException initializationException) {
            int n13 = 10748162;
            String string13 = MessageHandler.getMessage(n13, initializationException.getMessage());
            System.err.println(string13);
            return 1;
        }
        catch (Exception exception) {
            int n14 = 10748162;
            String string14 = MessageHandler.getMessage(n14, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string14);
            return 1;
        }
        try {
            object2 = new CoreConfigManager();
            ((CoreConfigManager)object2).initializeCoreConfig();
        }
        catch (ConfigException configException) {
            int n15 = 10748163;
            String string15 = MessageHandler.getMessage(n15, configException.getMessage());
            System.err.println(string15);
            return 1;
        }
        catch (InitializationException initializationException) {
            int n16 = 10748163;
            String string16 = MessageHandler.getMessage(n16, initializationException.getMessage());
            System.err.println(string16);
            return 1;
        }
        catch (Exception exception) {
            int n17 = 10748163;
            String string17 = MessageHandler.getMessage(n17, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string17);
            return 1;
        }
        try {
            directoryServer.initializeCryptoManager();
        }
        catch (ConfigException configException) {
            int n18 = 10748190;
            String string18 = MessageHandler.getMessage(n18, configException.getMessage());
            System.err.println(string18);
            return 1;
        }
        catch (InitializationException initializationException) {
            int n19 = 10748190;
            String string19 = MessageHandler.getMessage(n19, initializationException.getMessage());
            System.err.println(string19);
            return 1;
        }
        catch (Exception exception) {
            int n20 = 10748190;
            String string20 = MessageHandler.getMessage(n20, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string20);
            return 1;
        }
        object2 = new StartupErrorLogger();
        ((StartupErrorLogger)object2).initializeErrorLogger(null);
        Error.addErrorLogger((ErrorLogger)object2);
        ArrayList<Backend> arrayList = new ArrayList<Backend>();
        ArrayList<ConfigEntry> arrayList2 = new ArrayList<ConfigEntry>();
        ArrayList<List<DN>> arrayList3 = new ArrayList<List<DN>>();
        BackUpDB.getBackends(arrayList, arrayList2, arrayList3);
        int n21 = arrayList.size();
        ArrayList<Backend> arrayList4 = new ArrayList<Backend>(n21);
        HashMap<String, ConfigEntry> hashMap = new HashMap<String, ConfigEntry>(n21);
        if (booleanArgument.isPresent()) {
            for (n = 0; n < n21; ++n) {
                Backend backend = arrayList.get(n);
                if (!backend.supportsBackup()) continue;
                arrayList4.add(backend);
                hashMap.put(backend.getBackendID(), arrayList2.get(n));
            }
            bl = true;
        } else {
            String string2;
            int n2;
            HashSet<String> hashSet = new HashSet<String>(arrayList.size());
            hashSet.addAll(stringArgument.getValues());
            for (int i = 0; i < n21; ++i) {
                Backend object4 = arrayList.get(i);
                if (!hashSet.contains(object4.getBackendID())) continue;
                if (!object4.supportsBackup()) {
                    n2 = 10617110;
                    string2 = MessageHandler.getMessage(n2, object4.getBackendID());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string2, n2);
                    continue;
                }
                arrayList4.add(object4);
                hashMap.put(object4.getBackendID(), arrayList2.get(i));
                hashSet.remove(object4.getBackendID());
            }
            if (!hashSet.isEmpty()) {
                for (String string3 : hashSet) {
                    n2 = 10748165;
                    string2 = MessageHandler.getMessage(n2, string3);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n2);
                }
                return 1;
            }
            boolean bl2 = bl = arrayList4.size() > 1;
        }
        if (arrayList4.isEmpty()) {
            n = 10617111;
            String string22 = MessageHandler.getMessage(n);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string22, n);
            return 1;
        }
        n = 0;
        for (Backend backend : arrayList4) {
            CharSequence exception;
            StringBuilder stringBuilder;
            CharSequence charSequence;
            Object object;
            Object object4;
            BackupDirectory backupDirectory;
            ConfigEntry configEntry;
            int n3;
            CharSequence charSequence2;
            block76: {
                String string4;
                block75: {
                    try {
                        String string5 = LockFileManager.getBackendLockFileName(backend);
                        charSequence2 = new StringBuilder();
                        if (!LockFileManager.acquireSharedLock(string5, charSequence2)) {
                            int n4 = 10748232;
                            string4 = MessageHandler.getMessage(n4, backend.getBackendID(), String.valueOf(charSequence2));
                            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string4, n4);
                            n = 1;
                        }
                        break block75;
                    }
                    catch (Exception exception2) {
                        int n5 = 10748232;
                        String string6 = MessageHandler.getMessage(n5, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception2));
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string6, n5);
                        n = 1;
                    }
                    continue;
                }
                n3 = 10944792;
                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)charSequence2, n3);
                configEntry = (ConfigEntry)hashMap.get(backend.getBackendID());
                string4 = bl ? stringArgument5.getValue() + File.separator + backend.getBackendID() : stringArgument5.getValue();
                backupDirectory = null;
                file = new File(string4);
                if (file.exists()) {
                    object4 = string4 + File.separator + "backup.info";
                    object = new File((String)object4);
                    if (((File)object).exists()) {
                        try {
                            backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(string4);
                            break block76;
                        }
                        catch (ConfigException configException) {
                            n3 = 10748185;
                            charSequence2 = MessageHandler.getMessage(n3, object4, configException.getMessage());
                            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence2, n3);
                            n = 1;
                            try {
                                charSequence = LockFileManager.getBackendLockFileName(backend);
                                if (LockFileManager.releaseLock(charSequence, stringBuilder = new StringBuilder())) continue;
                                n3 = 10617161;
                                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(stringBuilder));
                                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                            }
                            catch (Exception exception3) {
                                n3 = 10617161;
                                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception3));
                                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                            }
                            continue;
                        }
                        catch (Exception exception4) {
                            n3 = 10748185;
                            charSequence2 = MessageHandler.getMessage(n3, object4, StaticUtils.stackTraceToSingleLineString(exception4));
                            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence2, n3);
                            n = 1;
                            try {
                                charSequence = LockFileManager.getBackendLockFileName(backend);
                                if (LockFileManager.releaseLock(charSequence, stringBuilder = new StringBuilder())) continue;
                                n3 = 10617161;
                                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(stringBuilder));
                                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                            }
                            catch (Exception exception5) {
                                n3 = 10617161;
                                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception5));
                                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                            }
                            continue;
                        }
                    }
                    backupDirectory = new BackupDirectory(string4, configEntry.getDN());
                } else {
                    try {
                        file.mkdirs();
                    }
                    catch (Exception exception6) {
                        n3 = 10748181;
                        charSequence2 = MessageHandler.getMessage(n3, string4, StaticUtils.stackTraceToSingleLineString(exception6));
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence2, n3);
                        n = 1;
                        try {
                            object = LockFileManager.getBackendLockFileName(backend);
                            if (LockFileManager.releaseLock((String)object, exception = new StringBuilder())) continue;
                            n3 = 10617161;
                            charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(exception));
                            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                        }
                        catch (Exception exception7) {
                            n3 = 10617161;
                            charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception7));
                            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                        }
                        continue;
                    }
                    backupDirectory = new BackupDirectory(string4, configEntry.getDN());
                }
            }
            object4 = new BackupConfig(backupDirectory, string, booleanArgument6.isPresent());
            ((BackupConfig)object4).setCompressData(booleanArgument2.isPresent());
            ((BackupConfig)object4).setEncryptData(booleanArgument4.isPresent());
            ((BackupConfig)object4).setHashData(booleanArgument5.isPresent());
            ((BackupConfig)object4).setSignHash(booleanArgument7.isPresent());
            ((BackupConfig)object4).setIncrementalBaseID((String)object3);
            object = new StringBuilder();
            if (!backend.supportsBackup((BackupConfig)object4, (StringBuilder)object)) {
                n3 = 10748168;
                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), ((StringBuilder)object).toString());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence2, n3);
                n = 1;
                try {
                    exception = LockFileManager.getBackendLockFileName(backend);
                    if (LockFileManager.releaseLock((String)exception, (StringBuilder)(charSequence = new StringBuilder()))) continue;
                    n3 = 10617161;
                    charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(charSequence));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                }
                catch (Exception exception8) {
                    n3 = 10617161;
                    charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception8));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                }
                continue;
            }
            try {
                backend.createBackup(configEntry, (BackupConfig)object4);
            }
            catch (DirectoryException directoryException) {
                n3 = 10748169;
                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), directoryException.getErrorMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence2, n3);
                n = 1;
                try {
                    charSequence = LockFileManager.getBackendLockFileName(backend);
                    if (LockFileManager.releaseLock(charSequence, stringBuilder = new StringBuilder())) continue;
                    n3 = 10617161;
                    charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(stringBuilder));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                }
                catch (Exception exception9) {
                    n3 = 10617161;
                    charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception9));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                }
                continue;
            }
            catch (Exception exception10) {
                n3 = 10748169;
                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception10));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence2, n3);
                n = 1;
                try {
                    charSequence = LockFileManager.getBackendLockFileName(backend);
                    if (LockFileManager.releaseLock(charSequence, stringBuilder = new StringBuilder())) continue;
                    n3 = 10617161;
                    charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(stringBuilder));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                }
                catch (Exception exception11) {
                    n3 = 10617161;
                    charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception11));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                }
                continue;
            }
            try {
                exception = LockFileManager.getBackendLockFileName(backend);
                if (LockFileManager.releaseLock((String)exception, (StringBuilder)(charSequence = new StringBuilder()))) continue;
                n3 = 10617161;
                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), String.valueOf(charSequence));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                n = 1;
            }
            catch (Exception exception12) {
                n3 = 10617161;
                charSequence2 = MessageHandler.getMessage(n3, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception12));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence2, n3);
                n = 1;
            }
        }
        if (n != 0) {
            int n26 = 10944794;
            String string7 = MessageHandler.getMessage(n26);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string7, n26);
        } else {
            int n27 = 10944795;
            String string8 = MessageHandler.getMessage(n27);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string8, n27);
        }
        return 0;
    }

    private static void getBackends(ArrayList<Backend> arrayList, ArrayList<ConfigEntry> arrayList2, ArrayList<List<DN>> arrayList3) {
        String string;
        String string2;
        int n;
        DN dN = null;
        try {
            dN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException directoryException) {
            n = 10748170;
            string2 = MessageHandler.getMessage(n, "cn=Backends,cn=config", directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            System.exit(1);
        }
        catch (Exception exception) {
            n = 10748170;
            string2 = MessageHandler.getMessage(n, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            System.exit(1);
        }
        ConfigEntry configEntry = null;
        try {
            configEntry = DirectoryServer.getConfigEntry(dN);
        }
        catch (ConfigException configException) {
            int n2 = 10748171;
            string = MessageHandler.getMessage(n2, "cn=Backends,cn=config", configException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n2);
            System.exit(1);
        }
        catch (Exception exception) {
            int n3 = 10748171;
            string = MessageHandler.getMessage(n3, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n3);
            System.exit(1);
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            Object object;
            Object object2;
            List<DN> list;
            Object object3;
            string = null;
            try {
                int n4 = 3146110;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n4), true, false, true);
                object3 = (StringConfigAttribute)configEntry2.getConfigAttribute(stringConfigAttribute);
                if (object3 == null) continue;
                string = ((StringConfigAttribute)object3).activeValue();
            }
            catch (ConfigException configException) {
                int n5 = 10748177;
                object3 = MessageHandler.getMessage(n5, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n5);
                System.exit(1);
            }
            catch (Exception exception) {
                int n6 = 10748177;
                object3 = MessageHandler.getMessage(n6, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n6);
                System.exit(1);
            }
            String string3 = null;
            try {
                int n7 = 3145837;
                object3 = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n7), true, false, false);
                list = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (list == null) continue;
                string3 = ((StringConfigAttribute)((Object)list)).activeValue();
            }
            catch (ConfigException configException) {
                int n8 = 10748172;
                list = MessageHandler.getMessage(n8, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)((Object)list), n8);
                System.exit(1);
            }
            catch (Exception exception) {
                int n9 = 10748172;
                list = MessageHandler.getMessage(n9, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)((Object)list), n9);
                System.exit(1);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3);
            }
            catch (Exception exception) {
                int n10 = 10748173;
                String string4 = MessageHandler.getMessage(n10, string3, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string4, n10);
                System.exit(1);
            }
            object3 = null;
            try {
                object3 = (Backend)clazz.newInstance();
                ((Backend)object3).setBackendID(string);
            }
            catch (Exception exception) {
                int n11 = 10748174;
                object2 = MessageHandler.getMessage(n11, string3, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n11);
                System.exit(1);
            }
            list = null;
            try {
                int n12 = 0x300131;
                object2 = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n12), true, true, true);
                object = (DNConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object2);
                if (object == null) {
                    n12 = 10748175;
                    String string5 = MessageHandler.getMessage(n12, String.valueOf(configEntry2.getDN()));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string5, n12);
                } else {
                    list = ((DNConfigAttribute)object).activeValues();
                }
            }
            catch (Exception exception) {
                int n13 = 10748176;
                object = MessageHandler.getMessage(n13, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object, n13);
                System.exit(1);
            }
            arrayList.add((Backend)object3);
            arrayList2.add(configEntry2);
            arrayList3.add(list);
        }
    }
}

