/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPCompareOptions;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCompare {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPCompare";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPCompare(AtomicInteger atomicInteger, PrintStream printStream, PrintStream printStream2) {
        this.nextMessageID = atomicInteger;
        this.out = printStream;
        this.err = printStream2;
    }

    public void readAndExecute(LDAPConnection lDAPConnection, String string, byte[] byArray, ArrayList<String> arrayList, LDAPCompareOptions lDAPCompareOptions) throws IOException, LDAPException {
        for (String string2 : arrayList) {
            this.executeCompare(lDAPConnection, string, byArray, string2, lDAPCompareOptions);
        }
    }

    public void readAndExecute(LDAPConnection lDAPConnection, String string, byte[] byArray, Reader reader, LDAPCompareOptions lDAPCompareOptions) throws IOException, LDAPException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            this.executeCompare(lDAPConnection, string, byArray, string2, lDAPCompareOptions);
        }
        bufferedReader.close();
    }

    private void executeCompare(LDAPConnection lDAPConnection, String string, byte[] byArray, String string2, LDAPCompareOptions lDAPCompareOptions) throws IOException, LDAPException {
        ArrayList<LDAPControl> arrayList = lDAPCompareOptions.getControls();
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
        ASN1OctetString aSN1OctetString2 = new ASN1OctetString(byArray);
        CompareRequestProtocolOp compareRequestProtocolOp = new CompareRequestProtocolOp(aSN1OctetString, string, aSN1OctetString2);
        int n = 10485867;
        this.out.println(MessageHandler.getMessage(n, string, aSN1OctetString2, aSN1OctetString));
        if (!lDAPCompareOptions.showOperations()) {
            Object object;
            int n2;
            Object object2;
            LDAPMessage lDAPMessage = null;
            try {
                object2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), compareRequestProtocolOp, arrayList);
                n2 = lDAPConnection.getASN1Writer().writeElement(((LDAPMessage)object2).encode());
                object = lDAPConnection.getASN1Reader().readElement();
                lDAPMessage = LDAPMessage.decode(ASN1Sequence.decodeAsSequence((ASN1Element)object));
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "executeCompare", aSN1Exception));
                if (!lDAPCompareOptions.continueOnError()) {
                    throw new IOException(aSN1Exception.getMessage());
                }
                n = 10485865;
                String string3 = MessageHandler.getMessage(n, "COMPARE", string2, aSN1Exception.getMessage());
                this.err.println(string3);
                return;
            }
            object2 = lDAPMessage.getCompareResponseProtocolOp();
            n2 = ((CompareResponseProtocolOp)object2).getResultCode();
            object = ((CompareResponseProtocolOp)object2).getErrorMessage();
            if (n2 != 6 && n2 != 5 && !lDAPCompareOptions.continueOnError()) {
                n = 10485865;
                String string4 = MessageHandler.getMessage(n, "COMPARE", string2, object);
                throw new LDAPException(n2, n, string4);
            }
            if (n2 == 5) {
                n = 10485868;
                this.out.println(MessageHandler.getMessage(n, string2));
            } else if (n2 == 6) {
                n = 10485869;
                this.out.println(MessageHandler.getMessage(n, string2));
            } else {
                n = 10485865;
                String string5 = MessageHandler.getMessage(n, "COMPARE", string2, object);
                this.err.println(string5);
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = LDAPCompare.mainCompare(stringArray, true, System.out, System.err);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainCompare(String[] stringArray) {
        return LDAPCompare.mainCompare(stringArray, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainCompare(String[] stringArray, boolean bl, OutputStream outputStream, OutputStream outputStream2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string6;
        PrintStream printStream = outputStream == null ? NullOutputStream.printStream() : new PrintStream(outputStream);
        PrintStream printStream2 = outputStream2 == null ? NullOutputStream.printStream() : new PrintStream(outputStream2);
        LDAPConnectionOptions lDAPConnectionOptions = new LDAPConnectionOptions();
        LDAPCompareOptions lDAPCompareOptions = new LDAPCompareOptions();
        LDAPConnection lDAPConnection = null;
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        FileBasedArgument fileBasedArgument = null;
        StringArgument stringArgument4 = null;
        StringArgument stringArgument5 = null;
        StringArgument stringArgument6 = null;
        StringArgument stringArgument7 = null;
        Object var19_19 = null;
        StringArgument stringArgument8 = null;
        IntegerArgument integerArgument = null;
        IntegerArgument integerArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        StringArgument stringArgument9 = null;
        BooleanArgument booleanArgument4 = null;
        BooleanArgument booleanArgument5 = null;
        BooleanArgument booleanArgument6 = null;
        BooleanArgument booleanArgument7 = null;
        BooleanArgument booleanArgument8 = null;
        StringArgument stringArgument10 = null;
        StringArgument stringArgument11 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        byte[] byArray = null;
        InputStreamReader inputStreamReader = null;
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, false, true, 1, 0, " 'attribute:value' \"DN\" ...");
        try {
            booleanArgument2 = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            stringArgument2 = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument3 = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            fileBasedArgument = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFilename}", null, null, 10485874, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            stringArgument4 = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            stringArgument5 = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            stringArgument7 = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argumentParser.addArgument(stringArgument7);
            stringArgument6 = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            stringArgument8 = new StringArgument("host", Character.valueOf('h'), "host", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argumentParser.addArgument(stringArgument8);
            integerArgument = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argumentParser.addArgument(integerArgument);
            integerArgument2 = new IntegerArgument("version", Character.valueOf('V'), "version", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argumentParser.addArgument(integerArgument2);
            stringArgument10 = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 10486173, new Object[0]);
            argumentParser.addArgument(stringArgument10);
            booleanArgument3 = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            argumentParser.setUsageArgument(booleanArgument3, printStream);
            stringArgument9 = new StringArgument("controls", Character.valueOf('J'), "controls", false, false, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argumentParser.addArgument(stringArgument9);
            booleanArgument4 = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            booleanArgument5 = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            booleanArgument6 = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argumentParser.addArgument(booleanArgument6);
            booleanArgument7 = new BooleanArgument("startTLS", Character.valueOf('q'), "startTLS", 10485886, new Object[0]);
            argumentParser.addArgument(booleanArgument7);
            booleanArgument8 = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argumentParser.addArgument(booleanArgument8);
            stringArgument11 = new StringArgument("saslOptions", Character.valueOf('o'), "saslOptions", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argumentParser.addArgument(stringArgument11);
            booleanArgument = new BooleanArgument("no-op", Character.valueOf('n'), "noop", 10486087, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            stringArgument = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, "{filter}", null, null, 10486105, new Object[0]);
            argumentParser.addArgument(stringArgument);
        }
        catch (ArgumentException argumentException) {
            int n = 10747920;
            String string3 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(string3);
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10747921;
            String string4 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(string4);
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument3.isPresent()) {
            return 1;
        }
        if (stringArgument3.isPresent() && fileBasedArgument.isPresent()) {
            printStream2.println("ERROR: Both -w and -j flags specified. Please specify one.");
            return 1;
        }
        ArrayList<String> arrayList2 = argumentParser.getTrailingArguments();
        if (arrayList2.isEmpty()) {
            printStream2.println("No Attributes specified for comparison");
            return 1;
        }
        String string5 = arrayList2.remove(0);
        for (String string6 : arrayList2) {
            arrayList.add(string6);
        }
        int n = string5.indexOf(":");
        if (n == -1) {
            printStream2.println("Invalid attribute string:" + string5);
            printStream2.println("Attribute string must be in one of the following forms: attribute:value, attribute::base64value, attribute:<fileURL");
            return 1;
        }
        string2 = string5.substring(0, n);
        string6 = string5.substring(n + 1, string5.length());
        if (string6.length() > 0) {
            String string7;
            char c = string6.charAt(0);
            if (c == ':') {
                string7 = string6.substring(1, string6.length());
                try {
                    byArray = Base64.decode(string7);
                }
                catch (ParseException parseException) {
                    assert (Debug.debugException(CLASS_NAME, "main", parseException));
                    byArray = string6.getBytes();
                }
            } else if (c == '<') {
                string7 = string6.substring(1, string6.length());
                byArray = LDAPToolUtils.readBytesFromFile(string7);
            } else {
                byArray = string6.getBytes();
            }
        } else {
            byArray = string6.getBytes();
        }
        String string8 = stringArgument8.getValue();
        int n2 = 389;
        try {
            n2 = integerArgument.getIntValue();
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(argumentException.getMessage());
            return 1;
        }
        try {
            int n3 = integerArgument2.getIntValue();
            if (n3 != 2 && n3 != 3) {
                int n4 = 10682569;
                printStream2.println(MessageHandler.getMessage(n4, n3));
                return 1;
            }
            lDAPConnectionOptions.setVersionNumber(n3);
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(argumentException.getMessage());
            return 1;
        }
        String string9 = stringArgument2.getValue();
        String string10 = stringArgument10.getValue();
        String string11 = stringArgument3.getValue();
        if (string11 != null && string11.equals("-")) {
            try {
                printStream.print(MessageHandler.getMessage(10485959, string9));
                object4 = PasswordReader.readPassword();
                string11 = new String((char[])object4);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(exception.getMessage());
                return 1;
            }
        } else if (string11 == null) {
            string11 = fileBasedArgument.getValue();
        }
        object4 = stringArgument5.getValue();
        String string12 = stringArgument6.getValue();
        String string13 = stringArgument7.getValue();
        String string14 = null;
        lDAPCompareOptions.setShowOperations(booleanArgument.isPresent());
        lDAPCompareOptions.setVerbose(booleanArgument4.isPresent());
        lDAPCompareOptions.setContinueOnError(booleanArgument5.isPresent());
        lDAPCompareOptions.setEncoding(stringArgument4.getValue());
        if (stringArgument9.hasValue()) {
            object3 = stringArgument9.getValue();
            object2 = LDAPToolUtils.getControl((String)object3);
            if (object2 == null) {
                printStream2.println("Invalid control specified:" + (String)object3);
                printStream2.println(argumentParser.getUsage());
                return 1;
            }
            lDAPCompareOptions.getControls().add((LDAPControl)object2);
        }
        if (stringArgument.isPresent()) {
            object3 = stringArgument.getValue();
            try {
                object2 = LDAPFilter.decode((String)object3);
                object = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(((LDAPFilter)object2).encode().encode()));
                lDAPCompareOptions.getControls().add((LDAPControl)object);
            }
            catch (LDAPException lDAPException) {
                printStream2.println(MessageHandler.getMessage(10682711, lDAPException.getMessage()));
                return 1;
            }
        }
        lDAPConnectionOptions.setSASLExternal(booleanArgument8.isPresent());
        if (stringArgument11.isPresent()) {
            object3 = stringArgument11.getValues();
            object2 = ((AbstractSequentialList)object3).iterator();
            while (object2.hasNext()) {
                boolean bl2;
                object = (String)object2.next();
                if (!(((String)object).startsWith("mech=") ? !(bl2 = lDAPConnectionOptions.setSASLMechanism((String)object)) : !(bl2 = lDAPConnectionOptions.addSASLProperty((String)object)))) continue;
                return 1;
            }
        }
        lDAPConnectionOptions.setUseSSL(booleanArgument6.isPresent());
        lDAPConnectionOptions.setStartTLS(booleanArgument7.isPresent());
        if (lDAPConnectionOptions.useSASLExternal()) {
            if (!lDAPConnectionOptions.useSSL() && !lDAPConnectionOptions.useStartTLS()) {
                printStream2.println("SASL External requires either SSL or StartTLS options to be requested.");
                return 1;
            }
            if (object4 == null) {
                printStream2.println("SASL External requires a path to the SSL client certificate keystore.");
                return 1;
            }
        }
        try {
            if (bl) {
                DirectoryServer.bootstrapClient();
            }
            object3 = null;
            if (lDAPConnectionOptions.useSSL() || lDAPConnectionOptions.useStartTLS()) {
                object3 = new SSLConnectionFactory();
                ((SSLConnectionFactory)object3).init(booleanArgument2.isPresent(), (String)object4, string12, string13, string14);
                lDAPConnectionOptions.setSSLConnectionFactory((SSLConnectionFactory)object3);
            }
            object2 = new AtomicInteger(1);
            lDAPConnection = new LDAPConnection(string8, n2, lDAPConnectionOptions, printStream, printStream2);
            lDAPConnection.connectToHost(string9, string11, (AtomicInteger)object2);
            object = new LDAPCompare((AtomicInteger)object2, printStream, printStream2);
            if (string10 == null && arrayList.isEmpty()) {
                inputStreamReader = new InputStreamReader(System.in);
            } else if (string10 != null) {
                inputStreamReader = new FileReader(string10);
            }
            if (inputStreamReader != null) {
                ((LDAPCompare)object).readAndExecute(lDAPConnection, string2, byArray, inputStreamReader, lDAPCompareOptions);
            } else {
                ((LDAPCompare)object).readAndExecute(lDAPConnection, string2, byArray, arrayList, lDAPCompareOptions);
            }
        }
        catch (LDAPException lDAPException) {
            int n5;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
            printStream2.println(lDAPException.getMessage());
            int n6 = n5 = lDAPException.getResultCode();
            return n6;
        }
        catch (LDAPConnectionException lDAPConnectionException) {
            int n7;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPConnectionException));
            printStream2.println(lDAPConnectionException.getMessage());
            int n8 = n7 = lDAPConnectionException.getErrorCode();
            return n8;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "main", exception));
            printStream2.println(exception.getMessage());
            int n9 = 1;
            return n9;
        }
        finally {
            if (lDAPConnection != null) {
                lDAPConnection.close();
            }
        }
        return 0;
    }
}

