/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.LDAPToolOptions;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.SearchScope;

public class LDAPSearchOptions
extends LDAPToolOptions {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPSearchOptions";
    private DereferencePolicy dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
    private SearchScope searchScope = SearchScope.WHOLE_SUBTREE;
    private int sizeLimit = 0;
    private int timeLimit = 0;
    private boolean typesOnly = false;

    public LDAPSearchOptions() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setSizeLimit(int n) {
        this.sizeLimit = n;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public boolean setSearchScope(String string) {
        if (string == null) {
            this.searchScope = SearchScope.WHOLE_SUBTREE;
        } else if (string.equals("base")) {
            this.searchScope = SearchScope.BASE_OBJECT;
        } else if (string.equals("one")) {
            this.searchScope = SearchScope.SINGLE_LEVEL;
        } else if (string.equals("sub")) {
            this.searchScope = SearchScope.WHOLE_SUBTREE;
        } else if (string.equals("subordinate")) {
            this.searchScope = SearchScope.SUBORDINATE_SUBTREE;
        } else {
            int n = 10748109;
            System.err.println(MessageHandler.getMessage(n, string));
            return false;
        }
        return true;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public boolean setDereferencePolicy(String string) {
        if (string == null) {
            this.dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
        } else if (string.equals("never")) {
            this.dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
        } else if (string.equals("always")) {
            this.dereferencePolicy = DereferencePolicy.DEREF_ALWAYS;
        } else if (string.equals("search")) {
            this.dereferencePolicy = DereferencePolicy.DEREF_IN_SEARCHING;
        } else if (string.equals("find")) {
            this.dereferencePolicy = DereferencePolicy.DEREF_FINDING_BASE_OBJECT;
        } else {
            System.err.println("Invalid deref alias specified:" + string);
            return false;
        }
        return true;
    }

    public DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean bl) {
        this.typesOnly = bl;
    }
}

