/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.MakeLDIFInputStreamThread;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;

public class MakeLDIFInputStream
extends InputStream
implements EntryWriter {
    private boolean allGenerated;
    private boolean closed;
    private ByteArrayOutputStream entryOutputStream;
    private ByteBuffer entryBytes;
    private IOException ioException;
    private LDIFWriter ldifWriter;
    private LinkedBlockingQueue<Entry> entryQueue;
    private MakeLDIFInputStreamThread generatorThread;
    private TemplateFile templateFile;

    public MakeLDIFInputStream(TemplateFile templateFile) {
        this.templateFile = templateFile;
        this.allGenerated = false;
        this.closed = false;
        this.entryQueue = new LinkedBlockingQueue(10);
        this.ioException = null;
        this.entryBytes = null;
        this.entryOutputStream = new ByteArrayOutputStream(8192);
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(this.entryOutputStream);
        try {
            this.ldifWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (IOException iOException) {
            this.ioException = iOException;
        }
        this.generatorThread = new MakeLDIFInputStreamThread(this, templateFile);
        this.generatorThread.start();
    }

    public void close() {
        this.closed = true;
        this.ioException = null;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (!(this.entryBytes != null && this.entryBytes.hasRemaining() || this.getNextEntry())) {
            this.closed = true;
            return -1;
        }
        return 0xFF & this.entryBytes.get();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (!(this.entryBytes != null && this.entryBytes.hasRemaining() || this.getNextEntry())) {
            this.closed = true;
            return -1;
        }
        int n3 = Math.min(n2, this.entryBytes.remaining());
        this.entryBytes.get(byArray, n, n3);
        return n3;
    }

    public boolean writeEntry(Entry entry) throws IOException, MakeLDIFException {
        while (!this.closed) {
            try {
                if (!this.entryQueue.offer(entry, 500L, TimeUnit.MILLISECONDS)) continue;
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    public void closeEntryWriter() {
        this.allGenerated = true;
    }

    void setIOException(IOException iOException) {
        this.ioException = iOException;
    }

    private boolean getNextEntry() {
        Entry entry = this.entryQueue.poll();
        while (entry == null) {
            if (this.closed) {
                return false;
            }
            if (this.allGenerated) {
                entry = this.entryQueue.poll();
                if (entry != null) continue;
                return false;
            }
            try {
                entry = this.entryQueue.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.entryOutputStream.reset();
            this.ldifWriter.writeEntry(entry);
            this.ldifWriter.flush();
            this.entryBytes = ByteBuffer.wrap(this.entryOutputStream.toByteArray());
        }
        catch (LDIFException lDIFException) {
            this.ioException = new IOException(lDIFException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            this.ioException = iOException;
            return false;
        }
        return true;
    }
}

