/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.BitSet;
import org.opends.server.config.ConfigException;
import org.opends.server.messages.MessageHandler;

public final class AddressMask {
    private static final String CLASS_NAME = "org.opends.server.types.AddressMask";
    private RuleType ruleType;
    public static int IN4ADDRSZ = 4;
    private int IPV4MAXPREFIX = 32;
    private byte[] ruleMask;
    private byte[] prefixMask;
    private BitSet wildCard = new BitSet();
    private String[] hostName;
    private String hostPattern;
    private String ruleString;

    private AddressMask(String string) throws ConfigException {
        this.determineRuleType(string);
        switch (this.ruleType) {
            case IPv4: {
                this.processIpv4(string);
                break;
            }
            case HOST: {
                this.processHost(string);
                break;
            }
            case HOSTPATTERN: {
                this.processHostPattern(string);
                break;
            }
            case ALLWILDCARD: {
                this.processAllWilds(string);
            }
        }
        this.ruleString = string;
    }

    private void determineRuleType(String string) throws ConfigException {
        if (string.endsWith(".")) {
            int n = 2359678;
            String string2 = MessageHandler.getMessage(n);
            throw new ConfigException(n, string2);
        }
        if (string.startsWith(".")) {
            this.ruleType = RuleType.HOSTPATTERN;
        } else {
            if (string.startsWith("[")) {
                int n = 2359678;
                String string3 = MessageHandler.getMessage(n);
                throw new ConfigException(n, string3);
            }
            int n = 0;
            String[] stringArray = string.split("\\.", -1);
            this.ruleType = RuleType.HOST;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("*")) {
                    ++n;
                    continue;
                }
                if (!Character.isDigit(stringArray[i].charAt(0))) continue;
                this.ruleType = RuleType.IPv4;
                break;
            }
            if (n == stringArray.length) {
                this.ruleType = RuleType.ALLWILDCARD;
            }
        }
    }

    private void processIpv4(String string) throws ConfigException {
        String[] stringArray = string.split("/", -1);
        this.ruleMask = new byte[IN4ADDRSZ];
        this.prefixMask = new byte[IN4ADDRSZ];
        this.prefixMask(this.processPrefix(stringArray, this.IPV4MAXPREFIX));
        this.processIpv4Subnet(stringArray.length == 0 ? string : stringArray[0]);
    }

    private void processAllWilds(String string) {
        String[] stringArray = string.split("\\.", -1);
        if (stringArray.length == IN4ADDRSZ) {
            for (int i = 0; i < IN4ADDRSZ; ++i) {
                this.wildCard.set(i);
            }
        }
        this.hostName = string.split("\\.", -1);
    }

    private void processHostPattern(String string) throws ConfigException {
        String[] stringArray = string.split("^[0-9a-zA-z-.]+");
        if (stringArray.length > 0) {
            int n = 2359678;
            String string2 = MessageHandler.getMessage(n);
            throw new ConfigException(n, string2);
        }
        this.hostPattern = string;
    }

    private void processHost(String string) throws ConfigException {
        String[] stringArray = string.split("^[0-9a-zA-z-.*]+");
        if (stringArray.length > 0) {
            int n = 2359678;
            String string2 = MessageHandler.getMessage(n);
            throw new ConfigException(n, string2);
        }
        this.hostName = string.split("\\.", -1);
    }

    private void prefixMask(int n) {
        int n2 = 0;
        n2 = 0;
        while (n > 8) {
            this.prefixMask[n2] = -1;
            n -= 8;
            ++n2;
        }
        this.prefixMask[n2] = (byte)(255 << 8 - n);
    }

    private void processIpv4Subnet(String string) throws ConfigException {
        String[] stringArray = string.split("\\.", -1);
        try {
            if (stringArray.length != IN4ADDRSZ) {
                int n = 2359678;
                String string2 = MessageHandler.getMessage(n);
                throw new ConfigException(n, string2);
            }
            for (int i = 0; i < IN4ADDRSZ; ++i) {
                String string3 = stringArray[i].trim();
                if (string3.equals("*")) {
                    this.wildCard.set(i);
                    continue;
                }
                long l = Integer.parseInt(string3);
                if (l < 0L || l > 255L) {
                    int n = 2359678;
                    String string4 = MessageHandler.getMessage(n);
                    throw new ConfigException(n, string4);
                }
                this.ruleMask[i] = (byte)(l & 0xFFL);
            }
        }
        catch (NumberFormatException numberFormatException) {
            int n = 2359678;
            String string5 = MessageHandler.getMessage(n);
            throw new ConfigException(n, string5);
        }
    }

    private int processPrefix(String[] stringArray, int n) throws ConfigException {
        int n2 = n;
        try {
            if (stringArray.length < 1 || stringArray.length > 2) {
                int n3 = 2359678;
                String string = MessageHandler.getMessage(n3);
                throw new ConfigException(n3, string);
            }
            if (stringArray.length == 2) {
                if (stringArray[0].indexOf(42) > -1) {
                    int n4 = 2359677;
                    String string = MessageHandler.getMessage(n4);
                    throw new ConfigException(n4, string);
                }
                n2 = Integer.parseInt(stringArray[1]);
            }
            if (n2 < 0 || n2 > n) {
                int n5 = 2359676;
                String string = MessageHandler.getMessage(n5);
                throw new ConfigException(n5, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            int n6 = 2359678;
            String string = MessageHandler.getMessage(n6);
            throw new ConfigException(n6, string);
        }
        return n2;
    }

    public static AddressMask decode(String string) throws ConfigException {
        return new AddressMask(string);
    }

    public static boolean maskListContains(byte[] byArray, String string, AddressMask[] addressMaskArray) {
        for (int i = 0; i < addressMaskArray.length; ++i) {
            if (!addressMaskArray[i].match(byArray, string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this.ruleString);
    }

    private boolean match(byte[] byArray, String string) {
        boolean bl = false;
        switch (this.ruleType) {
            case IPv4: {
                bl = this.matchAddress(byArray);
                break;
            }
            case HOST: {
                bl = this.matchHostName(string);
                break;
            }
            case HOSTPATTERN: {
                bl = this.matchPattern(string);
                break;
            }
            case ALLWILDCARD: {
                bl = this.matchAddress(byArray);
                if (bl) break;
                bl = this.matchHostName(string);
            }
        }
        return bl;
    }

    private boolean matchPattern(String string) {
        int n = string.length() - this.hostPattern.length();
        if (n > 0) {
            return string.regionMatches(true, n, this.hostPattern, 0, this.hostPattern.length());
        }
        return false;
    }

    private boolean matchHostName(String string) {
        String[] stringArray = string.split("\\.", -1);
        if (stringArray.length != this.hostName.length) {
            return false;
        }
        if (this.ruleType == RuleType.ALLWILDCARD) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.hostName[i].equals("*") || stringArray[i].equalsIgnoreCase(this.hostName[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchAddress(byte[] byArray) {
        if (this.prefixMask == null) {
            return false;
        }
        if (byArray.length != this.prefixMask.length) {
            return false;
        }
        if (this.ruleType == RuleType.ALLWILDCARD) {
            return true;
        }
        for (int i = 0; i < this.prefixMask.length; ++i) {
            if (this.wildCard.get(i) || (this.ruleMask[i] & this.prefixMask[i]) == (byArray[i] & this.prefixMask[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RuleType {
        IPv4,
        IPv6,
        HOSTPATTERN,
        ALLWILDCARD,
        HOST;

    }
}

