/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeType {
    private static final String CLASS_NAME = "org.opends.server.types.AttributeType";
    private final ApproximateMatchingRule approximateMatchingRule;
    private final AttributeSyntax syntax;
    private final AttributeType superiorType;
    private final AttributeUsage attributeUsage;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObjectClassType;
    private final boolean isObsolete;
    private final boolean isSingleValue;
    private final Map<String, List<String>> extraProperties;
    private final Map<String, String> typeNames;
    private final EqualityMatchingRule equalityMatchingRule;
    private final OrderingMatchingRule orderingMatchingRule;
    private final String description;
    private final String oid;
    private final String primaryName;
    private final String lowerName;
    private final SubstringMatchingRule substringMatchingRule;

    public AttributeType(String string, Collection<String> collection, String string2, String string3, AttributeType attributeType, AttributeSyntax attributeSyntax, AttributeUsage attributeUsage, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, collection, string2, string3, attributeType, attributeSyntax, null, null, null, null, attributeUsage, bl, bl2, bl3, bl4, null);
    }

    public AttributeType(String string, Collection<String> collection, String string2, String string3, AttributeType attributeType, AttributeSyntax attributeSyntax, ApproximateMatchingRule approximateMatchingRule, EqualityMatchingRule equalityMatchingRule, OrderingMatchingRule orderingMatchingRule, SubstringMatchingRule substringMatchingRule, AttributeUsage attributeUsage, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map<String, List<String>> map) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(collection), String.valueOf(string2), String.valueOf(string3), String.valueOf(attributeType), String.valueOf(attributeSyntax), String.valueOf(approximateMatchingRule), String.valueOf(equalityMatchingRule), String.valueOf(orderingMatchingRule), String.valueOf(substringMatchingRule), String.valueOf((Object)attributeUsage), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(map)));
        if (string2 == null) {
            throw new NullPointerException("No oid specified in constructor");
        }
        this.primaryName = string;
        this.lowerName = StaticUtils.toLowerCase(string);
        this.oid = string2;
        this.description = string3;
        this.superiorType = attributeType;
        this.isCollective = bl;
        this.isNoUserModification = bl2;
        this.isObsolete = bl3;
        this.isSingleValue = bl4;
        if (collection != null) {
            this.typeNames = new HashMap<String, String>(collection.size());
            for (String string4 : collection) {
                this.typeNames.put(StaticUtils.toLowerCase(string4), string4);
            }
        } else {
            this.typeNames = new HashMap<String, String>();
        }
        if (this.lowerName != null && !this.typeNames.containsKey(this.lowerName)) {
            this.typeNames.put(this.lowerName, this.primaryName);
        }
        this.syntax = attributeSyntax == null ? (attributeType != null ? attributeType.getSyntax() : DirectoryServer.getDefaultAttributeSyntax()) : attributeSyntax;
        this.approximateMatchingRule = approximateMatchingRule == null ? this.syntax.getApproximateMatchingRule() : approximateMatchingRule;
        this.equalityMatchingRule = equalityMatchingRule == null ? this.syntax.getEqualityMatchingRule() : equalityMatchingRule;
        this.orderingMatchingRule = orderingMatchingRule == null ? this.syntax.getOrderingMatchingRule() : orderingMatchingRule;
        this.substringMatchingRule = substringMatchingRule == null ? this.syntax.getSubstringMatchingRule() : substringMatchingRule;
        this.attributeUsage = attributeUsage != null ? attributeUsage : AttributeUsage.USER_APPLICATIONS;
        this.isObjectClassType = string2.equals("2.5.4.0") ? true : this.typeNames.containsKey("objectclass");
        this.extraProperties = map != null ? new HashMap<String, List<String>>(map) : Collections.emptyMap();
    }

    public String getPrimaryName() {
        assert (Debug.debugEnter(CLASS_NAME, "getPrimaryName", new String[0]));
        return this.primaryName;
    }

    public String getNormalizedPrimaryName() {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedPrimaryName", new String[0]));
        return this.lowerName;
    }

    public Iterable<String> getNormalizedNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedNames", new String[0]));
        return this.typeNames.keySet();
    }

    public Iterable<String> getUserDefinedNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserDefinedNames", new String[0]));
        return this.typeNames.values();
    }

    public boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.typeNames.containsKey(string);
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public String getNameOrOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameOrOID", new String[0]));
        if (this.primaryName != null) {
            return this.primaryName;
        }
        if (this.typeNames.isEmpty()) {
            return this.oid;
        }
        return this.typeNames.values().iterator().next();
    }

    public boolean hasNameOrOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasNameOrOID", String.valueOf(string)));
        if (this.typeNames.containsKey(string)) {
            return true;
        }
        return this.oid.equals(string);
    }

    public String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        List<String> list = this.extraProperties.get("X-SCHEMA-FILE");
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public AttributeType getSuperiorType() {
        assert (Debug.debugEnter(CLASS_NAME, "getSuperiorType", new String[0]));
        return this.superiorType;
    }

    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return this.syntax;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return this.syntax.getOID();
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return this.approximateMatchingRule;
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.equalityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.orderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.substringMatchingRule;
    }

    public AttributeUsage getUsage() {
        assert (Debug.debugEnter(CLASS_NAME, "getUsage", new String[0]));
        return this.attributeUsage;
    }

    public boolean isOperational() {
        assert (Debug.debugEnter(CLASS_NAME, "isOperational", new String[0]));
        return this.attributeUsage.isOperational();
    }

    public boolean isCollective() {
        assert (Debug.debugEnter(CLASS_NAME, "isCollective", new String[0]));
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        assert (Debug.debugEnter(CLASS_NAME, "isNoUserModification", new String[0]));
        return this.isNoUserModification;
    }

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public boolean isSingleValue() {
        assert (Debug.debugEnter(CLASS_NAME, "isSingleValue", new String[0]));
        return this.isSingleValue;
    }

    public Iterable<String> getExtraPropertyNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraPropertyNames", new String[0]));
        return this.extraProperties.keySet();
    }

    public Iterable<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public boolean isObjectClassType() {
        assert (Debug.debugEnter(CLASS_NAME, "isObjectClassType", new String[0]));
        return this.isObjectClassType;
    }

    public ByteString normalize(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalize", String.valueOf(byteString)));
        if (this.equalityMatchingRule == null) {
            int n = 196733;
            String string = MessageHandler.getMessage(n, String.valueOf(byteString), this.getNameOrOID());
            throw new DirectoryException(ResultCode.INAPPROPRIATE_MATCHING, string, n);
        }
        return this.equalityMatchingRule.normalizeValue(byteString);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AttributeType)) {
            return false;
        }
        return this.oid.equals(((AttributeType)object).oid);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.oid.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.oid.charAt(i);
        }
        return n2;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "generateHashCode", String.valueOf(attributeValue)));
        try {
            if (this.equalityMatchingRule == null) {
                ByteString byteString = attributeValue.getNormalizedValue();
                if (byteString == null) {
                    return attributeValue.getValue().hashCode();
                }
                return byteString.hashCode();
            }
            return this.equalityMatchingRule.generateHashCode(attributeValue);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "generateHashCode", exception));
            try {
                return attributeValue.getValue().hashCode();
            }
            catch (Exception exception2) {
                assert (Debug.debugException(CLASS_NAME, "generateHashCode", exception2));
                return 0;
            }
        }
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (!this.typeNames.isEmpty()) {
            Iterator<Object> iterator = this.typeNames.values().iterator();
            String object = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(object);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append(iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(object);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (this.superiorType != null) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorType.getNameOrOID());
        }
        if (this.equalityMatchingRule != null) {
            stringBuilder.append(" EQUALITY ");
            stringBuilder.append(this.equalityMatchingRule.getNameOrOID());
        }
        if (this.orderingMatchingRule != null) {
            stringBuilder.append(" ORDERING ");
            stringBuilder.append(this.orderingMatchingRule.getNameOrOID());
        }
        if (this.substringMatchingRule != null) {
            stringBuilder.append(" SUBSTR ");
            stringBuilder.append(this.substringMatchingRule.getNameOrOID());
        }
        if (this.syntax != null) {
            stringBuilder.append(" SYNTAX ");
            stringBuilder.append(this.syntax.getOID());
        }
        if (this.isSingleValue) {
            stringBuilder.append(" SINGLE-VALUE");
        }
        if (this.isCollective) {
            stringBuilder.append(" COLLECTIVE");
        }
        if (this.isNoUserModification) {
            stringBuilder.append(" NO-USER-MODIFICATION");
        }
        if (this.attributeUsage != null) {
            stringBuilder.append(" USAGE ");
            stringBuilder.append(this.attributeUsage.toString());
        }
        if (!this.extraProperties.isEmpty()) {
            for (Map.Entry entry : this.extraProperties.entrySet()) {
                String string = (String)entry.getKey();
                if (!bl && string.equals("X-SCHEMA-FILE")) continue;
                List list = (List)entry.getValue();
                stringBuilder.append(" ");
                stringBuilder.append(string);
                if (list.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append((String)list.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string2 : list) {
                    stringBuilder.append("'");
                    stringBuilder.append(string2);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        stringBuilder.append(" )");
    }
}

