/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;

public class Control {
    private static final String CLASS_NAME = "org.opends.server.types.Control";
    private ASN1OctetString value;
    private boolean isCritical;
    private String oid;

    public Control(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(string), String.valueOf(bl)));
        this.oid = string;
        this.isCritical = bl;
        this.value = null;
    }

    public Control(String string, boolean bl, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(aSN1OctetString)));
        this.oid = string;
        this.isCritical = bl;
        this.value = aSN1OctetString;
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public boolean isCritical() {
        assert (Debug.debugEnter(CLASS_NAME, "isCritical", new String[0]));
        return this.isCritical;
    }

    public void setCritical(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setCritical", String.valueOf(bl)));
        this.isCritical = bl;
    }

    public ASN1OctetString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.value;
    }

    public boolean hasValue() {
        assert (Debug.debugEnter(CLASS_NAME, "hasValue", new String[0]));
        return this.value != null;
    }

    public void setValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(aSN1OctetString)));
        this.value = aSN1OctetString;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("Control(oid=");
        stringBuilder.append(this.oid);
        stringBuilder.append(",isCritical=");
        stringBuilder.append(this.isCritical);
        if (this.value != null) {
            stringBuilder.append(",value=");
            this.value.toString(stringBuilder);
        }
        stringBuilder.append(")");
    }
}

