/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DN
implements Comparable<DN>,
Serializable {
    private static final String CLASS_NAME = "org.opends.server.types.DN";
    private static final long serialVersionUID = 1184263456768819888L;
    private int numComponents;
    private RDN[] rdnComponents;
    private String dnString;
    private String normalizedDN;

    public DN() {
        this(new RDN[0]);
    }

    public DN(RDN[] rDNArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(rDNArray)));
        this.rdnComponents = rDNArray == null ? new RDN[0] : rDNArray;
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public DN(ArrayList<RDN> arrayList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(arrayList)));
        if (arrayList == null || arrayList.isEmpty()) {
            this.rdnComponents = new RDN[0];
        } else {
            this.rdnComponents = new RDN[arrayList.size()];
            arrayList.toArray(this.rdnComponents);
        }
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public DN(DN dN, DN dN2) {
        this(dN, dN2.rdnComponents);
    }

    public DN(DN dN, RDN[] rDNArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(rDNArray)));
        RDN[] rDNArray2 = new RDN[rDNArray.length + dN.numComponents];
        System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray.length);
        System.arraycopy(dN.rdnComponents, 0, rDNArray2, rDNArray.length, dN.numComponents);
        this.rdnComponents = rDNArray2;
        this.numComponents = rDNArray2.length;
        this.dnString = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public RDN[] getRDNComponents() {
        assert (Debug.debugEnter(CLASS_NAME, "getRDNComponents", new String[0]));
        return this.rdnComponents;
    }

    public void setRDNComponents(RDN[] rDNArray) {
        assert (Debug.debugEnter(CLASS_NAME, "setRDNComponents", String.valueOf(rDNArray)));
        this.rdnComponents = rDNArray == null ? new RDN[0] : rDNArray;
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public void setRDNComponents(ArrayList<RDN> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "setRDNComponents", String.valueOf(arrayList)));
        if (arrayList == null) {
            this.rdnComponents = new RDN[0];
        } else {
            this.rdnComponents = new RDN[arrayList.size()];
            arrayList.toArray(this.rdnComponents);
        }
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public RDN getRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRDN", new String[0]));
        if (this.numComponents == 0) {
            return null;
        }
        return this.rdnComponents[0];
    }

    public DN getParent() {
        assert (Debug.debugEnter(CLASS_NAME, "getParent", new String[0]));
        if (this.numComponents <= 1 || DirectoryServer.isSuffix(this)) {
            return null;
        }
        RDN[] rDNArray = new RDN[this.numComponents - 1];
        System.arraycopy(this.rdnComponents, 1, rDNArray, 0, this.numComponents - 1);
        return new DN(rDNArray);
    }

    public boolean isNullDN() {
        assert (Debug.debugEnter(CLASS_NAME, "isNullDN", new String[0]));
        return this.numComponents == 0;
    }

    public boolean isSuffix() {
        assert (Debug.debugEnter(CLASS_NAME, "isSuffix", new String[0]));
        return DirectoryServer.isSuffix(this);
    }

    public boolean isDescendantOf(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "isDescendantOf", String.valueOf(dN)));
        int n = this.numComponents - dN.numComponents;
        if (n < 0) {
            return false;
        }
        for (int i = 0; i < dN.numComponents; ++i) {
            if (this.rdnComponents[i + n].equals(dN.rdnComponents[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "isAncestorOf", String.valueOf(dN)));
        int n = dN.numComponents - this.numComponents;
        if (n < 0) {
            return false;
        }
        for (int i = 0; i < this.numComponents; ++i) {
            if (this.rdnComponents[i].equals(dN.rdnComponents[i + n])) continue;
            return false;
        }
        return true;
    }

    public static DN decode(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(byteString)));
        if (byteString == null) {
            return new DN(new ArrayList<RDN>(0));
        }
        byte[] byArray = byteString.value();
        int n = byArray.length;
        if (n == 0) {
            return new DN(new ArrayList<RDN>(0));
        }
        for (byte by : byArray) {
            if ((by & 0x7F) == by && by != 92) continue;
            return DN.decode(byteString.stringValue());
        }
        int n2 = 0;
        int n3 = byArray[n2];
        while (n3 == 32) {
            if (++n2 == n) {
                return new DN(new ArrayList<RDN>(0));
            }
            n3 = byArray[n2];
        }
        int n4 = DirectoryServer.allowAttributeNameExceptions() ? 1 : 0;
        ArrayList<RDN> arrayList = new ArrayList<RDN>();
        block2: while (true) {
            Object object;
            Object object2;
            Object object3;
            String string;
            StringBuilder stringBuilder;
            if ((n2 = DN.parseAttributeName(byArray, n2, stringBuilder = new StringBuilder(), n4 != 0)) >= n) {
                int n5 = 6488099;
                string = MessageHandler.getMessage(n5, byteString.stringValue(), stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n5);
            }
            n3 = byArray[n2];
            while (n3 == 32) {
                if (++n2 >= n) {
                    int n6 = 6488099;
                    string = MessageHandler.getMessage(n6, byteString.stringValue(), stringBuilder.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n6);
                }
                n3 = byArray[n2];
            }
            if (n3 == 61) {
                ++n2;
            } else {
                int n7 = 6488100;
                string = MessageHandler.getMessage(n7, byteString.stringValue(), stringBuilder.toString(), Character.valueOf((char)n3));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n7);
            }
            while (n2 < n && (n3 = byArray[n2]) == 32) {
                ++n2;
            }
            if (n2 >= n) {
                object3 = stringBuilder.toString();
                string = StaticUtils.toLowerCase((String)object3);
                object2 = DirectoryServer.getAttributeType(string);
                if (object2 == null) {
                    object2 = DirectoryServer.getDefaultAttributeType((String)object3);
                }
                object = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                arrayList.add(new RDN((AttributeType)object2, (String)object3, (AttributeValue)object));
                return new DN(arrayList);
            }
            object3 = new ASN1OctetString();
            n2 = DN.parseAttributeValue(byArray, n2, (ByteString)object3);
            string = stringBuilder.toString();
            object2 = StaticUtils.toLowerCase(string);
            object = DirectoryServer.getAttributeType((String)object2);
            if (object == null) {
                object = DirectoryServer.getDefaultAttributeType(string);
            }
            AttributeValue attributeValue = new AttributeValue((AttributeType)object, (ByteString)object3);
            RDN rDN = new RDN((AttributeType)object, string, attributeValue);
            while (n2 < n && (n3 = byArray[n2]) == 32) {
                ++n2;
            }
            if (n2 >= n) {
                arrayList.add(rDN);
                return new DN(arrayList);
            }
            if (n3 == 44 || n3 == 59) {
                arrayList.add(rDN);
                ++n2;
                continue;
            }
            if (n3 != 43) {
                int n8 = 6488101;
                String string2 = MessageHandler.getMessage(n8, new String(byArray), Character.valueOf((char)n3), n2);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n8);
            }
            do {
                ++n2;
                while (n2 < n && byArray[n2] == 32) {
                    ++n2;
                }
                stringBuilder = new StringBuilder();
                if ((n2 = DN.parseAttributeName(byArray, n2, stringBuilder, n4 != 0)) >= n) {
                    int n9 = 6488099;
                    String string3 = MessageHandler.getMessage(n9, byteString.stringValue(), stringBuilder.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n9);
                }
                n3 = byArray[n2];
                while (n3 == 32) {
                    if (++n2 >= n) {
                        int n10 = 6488099;
                        String string4 = MessageHandler.getMessage(n10, byteString.stringValue(), stringBuilder.toString());
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n10);
                    }
                    n3 = byArray[n2];
                }
                if (n3 == 61) {
                    ++n2;
                } else {
                    int n11 = 6488100;
                    String string5 = MessageHandler.getMessage(n11, byteString.stringValue(), stringBuilder.toString(), Character.valueOf((char)n3));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n11);
                }
                while (n2 < n && (n3 = byArray[n2]) == 32) {
                    ++n2;
                }
                if (n2 >= n) {
                    string = stringBuilder.toString();
                    object2 = StaticUtils.toLowerCase(string);
                    object = DirectoryServer.getAttributeType((String)object2);
                    if (object == null) {
                        object = DirectoryServer.getDefaultAttributeType(string);
                    }
                    attributeValue = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                    rDN.addValue((AttributeType)object, string, attributeValue);
                    arrayList.add(rDN);
                    return new DN(arrayList);
                }
                object3 = new ASN1OctetString();
                n2 = DN.parseAttributeValue(byArray, n2, (ByteString)object3);
                string = stringBuilder.toString();
                object2 = StaticUtils.toLowerCase(string);
                object = DirectoryServer.getAttributeType((String)object2);
                if (object == null) {
                    object = DirectoryServer.getDefaultAttributeType(string);
                }
                attributeValue = new AttributeValue((AttributeType)object, (ByteString)object3);
                rDN.addValue((AttributeType)object, string, attributeValue);
                while (n2 < n && (n3 = byArray[n2]) == 32) {
                    ++n2;
                }
                if (n2 >= n) {
                    arrayList.add(rDN);
                    return new DN(arrayList);
                }
                if (n3 != 44 && n3 != 59) continue;
                arrayList.add(rDN);
                ++n2;
                continue block2;
            } while (n3 == 43);
            break;
        }
        int n12 = 6488101;
        String string = MessageHandler.getMessage(n12, byteString.stringValue(), Character.valueOf((char)n3), n2);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n12);
    }

    public static DN decode(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        if (string == null) {
            return new DN(new ArrayList<RDN>(0));
        }
        int n = string.length();
        if (n == 0) {
            return new DN(new ArrayList<RDN>(0));
        }
        int n2 = 0;
        char c = string.charAt(n2);
        while (c == ' ') {
            if (++n2 == n) {
                return new DN(new ArrayList<RDN>(0));
            }
            c = string.charAt(n2);
        }
        boolean bl = DirectoryServer.allowAttributeNameExceptions();
        ArrayList<RDN> arrayList = new ArrayList<RDN>();
        block1: while (true) {
            Object object;
            Object object2;
            Object object3;
            String string2;
            StringBuilder stringBuilder;
            if ((n2 = DN.parseAttributeName(string, n2, stringBuilder = new StringBuilder(), bl)) >= n) {
                int n3 = 6488099;
                string2 = MessageHandler.getMessage(n3, string, stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n3);
            }
            c = string.charAt(n2);
            while (c == ' ') {
                if (++n2 >= n) {
                    int n4 = 6488099;
                    string2 = MessageHandler.getMessage(n4, string, stringBuilder.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n4);
                }
                c = string.charAt(n2);
            }
            if (c == '=') {
                ++n2;
            } else {
                int n5 = 6488100;
                string2 = MessageHandler.getMessage(n5, string, stringBuilder.toString(), Character.valueOf(c));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n5);
            }
            while (n2 < n && (c = string.charAt(n2)) == ' ') {
                ++n2;
            }
            if (n2 >= n) {
                object3 = stringBuilder.toString();
                string2 = StaticUtils.toLowerCase((String)object3);
                object2 = DirectoryServer.getAttributeType(string2);
                if (object2 == null) {
                    object2 = DirectoryServer.getDefaultAttributeType((String)object3);
                }
                object = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                arrayList.add(new RDN((AttributeType)object2, (String)object3, (AttributeValue)object));
                return new DN(arrayList);
            }
            object3 = new ASN1OctetString();
            n2 = DN.parseAttributeValue(string, n2, (ByteString)object3);
            string2 = stringBuilder.toString();
            object2 = StaticUtils.toLowerCase(string2);
            object = DirectoryServer.getAttributeType((String)object2);
            if (object == null) {
                object = DirectoryServer.getDefaultAttributeType(string2);
            }
            AttributeValue attributeValue = new AttributeValue((AttributeType)object, (ByteString)object3);
            RDN rDN = new RDN((AttributeType)object, string2, attributeValue);
            while (n2 < n && (c = string.charAt(n2)) == ' ') {
                ++n2;
            }
            if (n2 >= n) {
                arrayList.add(rDN);
                return new DN(arrayList);
            }
            if (c == ',' || c == ';') {
                arrayList.add(rDN);
                ++n2;
                continue;
            }
            if (c != '+') {
                int n6 = 6488101;
                String string3 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n2);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n6);
            }
            do {
                ++n2;
                while (n2 < n && string.charAt(n2) == ' ') {
                    ++n2;
                }
                stringBuilder = new StringBuilder();
                if ((n2 = DN.parseAttributeName(string, n2, stringBuilder, bl)) >= n) {
                    int n7 = 6488099;
                    String string4 = MessageHandler.getMessage(n7, string, stringBuilder.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n7);
                }
                c = string.charAt(n2);
                while (c == ' ') {
                    if (++n2 >= n) {
                        int n8 = 6488099;
                        String string5 = MessageHandler.getMessage(n8, string, stringBuilder.toString());
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n8);
                    }
                    c = string.charAt(n2);
                }
                if (c == '=') {
                    ++n2;
                } else {
                    int n9 = 6488100;
                    String string6 = MessageHandler.getMessage(n9, string, stringBuilder.toString(), Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string6, n9);
                }
                while (n2 < n && (c = string.charAt(n2)) == ' ') {
                    ++n2;
                }
                if (n2 >= n) {
                    string2 = stringBuilder.toString();
                    object2 = StaticUtils.toLowerCase(string2);
                    object = DirectoryServer.getAttributeType((String)object2);
                    if (object == null) {
                        object = DirectoryServer.getDefaultAttributeType(string2);
                    }
                    attributeValue = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                    rDN.addValue((AttributeType)object, string2, attributeValue);
                    arrayList.add(rDN);
                    return new DN(arrayList);
                }
                object3 = new ASN1OctetString();
                n2 = DN.parseAttributeValue(string, n2, (ByteString)object3);
                string2 = stringBuilder.toString();
                object2 = StaticUtils.toLowerCase(string2);
                object = DirectoryServer.getAttributeType((String)object2);
                if (object == null) {
                    object = DirectoryServer.getDefaultAttributeType(string2);
                }
                attributeValue = new AttributeValue((AttributeType)object, (ByteString)object3);
                rDN.addValue((AttributeType)object, string2, attributeValue);
                while (n2 < n && (c = string.charAt(n2)) == ' ') {
                    ++n2;
                }
                if (n2 >= n) {
                    arrayList.add(rDN);
                    return new DN(arrayList);
                }
                if (c != ',' && c != ';') continue;
                arrayList.add(rDN);
                ++n2;
                continue block1;
            } while (c == '+');
            break;
        }
        int n10 = 6488101;
        String string7 = MessageHandler.getMessage(n10, string, Character.valueOf(c), n2);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string7, n10);
    }

    public static int parseAttributeName(byte[] byArray, int n, StringBuilder stringBuilder, boolean bl) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeName", String.valueOf(byArray), String.valueOf(n), "java.lang.StringBuilder"));
        int n3 = byArray.length;
        if (n < n3) {
            while (byArray[n] == 32) {
                if (++n != n3) continue;
                int n4 = 6488090;
                String string = MessageHandler.getMessage(n4, new String(byArray));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n4);
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (n < n3) {
            n2 = byArray[n];
            switch (n2) {
                case 32: {
                    bl3 = true;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    int n5 = 6488092;
                    String string = MessageHandler.getMessage(n5, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n5);
                }
                case 45: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append((char)n2);
                        break;
                    }
                    int n6 = 6488094;
                    String string = MessageHandler.getMessage(n6, new String(byArray), Character.valueOf((char)n2));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n6);
                }
                case 46: {
                    stringBuilder.append((char)n2);
                    bl2 = true;
                    break;
                }
                case 47: {
                    int n7 = 6488092;
                    String string = MessageHandler.getMessage(n7, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n7);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    stringBuilder.append((char)n2);
                    break;
                }
                case 58: 
                case 59: 
                case 60: {
                    int n8 = 6488092;
                    String string = MessageHandler.getMessage(n8, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n8);
                }
                case 61: {
                    bl3 = true;
                    break;
                }
                case 62: 
                case 63: 
                case 64: {
                    int n9 = 6488092;
                    String string = MessageHandler.getMessage(n9, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n9);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    stringBuilder.append((char)n2);
                    break;
                }
                case 91: 
                case 92: 
                case 93: 
                case 94: {
                    int n10 = 6488092;
                    String string = MessageHandler.getMessage(n10, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n10);
                }
                case 95: {
                    if (stringBuilder.length() == 0) {
                        int n11 = 6488095;
                        String string = MessageHandler.getMessage(n11, new String(byArray), "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n11);
                    }
                    if (bl) {
                        stringBuilder.append((char)n2);
                        break;
                    }
                    int n12 = 6488093;
                    String string = MessageHandler.getMessage(n12, new String(byArray), "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n12);
                }
                case 96: {
                    int n13 = 6488092;
                    String string = MessageHandler.getMessage(n13, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n13);
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    stringBuilder.append((char)n2);
                    break;
                }
                default: {
                    int n14 = 6488092;
                    String string = MessageHandler.getMessage(n14, new String(byArray), Character.valueOf((char)n2), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n14);
                }
            }
            if (bl3) break;
            ++n;
        }
        if (stringBuilder.length() == 0) {
            n2 = 6488097;
            String string = MessageHandler.getMessage(n2, new String(byArray));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n2);
        }
        if (bl2) {
            n2 = 1;
            int n15 = 0;
            int n16 = stringBuilder.length();
            char c = stringBuilder.charAt(0);
            if (c == 'o' || c == 'O') {
                if (n16 <= 4) {
                    n2 = 0;
                } else {
                    c = stringBuilder.charAt(1);
                    if (!(c != 'i' && c != 'I' || (c = stringBuilder.charAt(2)) != 'd' && c != 'D' || stringBuilder.charAt(3) != '.')) {
                        stringBuilder.delete(0, 4);
                        n16 -= 4;
                    } else {
                        n2 = 0;
                    }
                }
            }
            while (n2 != 0 && n15 < n16) {
                if (StaticUtils.isDigit(c = stringBuilder.charAt(n15++))) {
                    while (n2 != 0 && n15 < n16 && StaticUtils.isDigit(stringBuilder.charAt(n15))) {
                        ++n15;
                    }
                    if (n15 >= n16 || stringBuilder.charAt(n15) == '.') continue;
                    n2 = 0;
                    continue;
                }
                if (c == '.') {
                    if (n15 != 1 && stringBuilder.charAt(n15 - 2) != '.') continue;
                    n2 = 0;
                    continue;
                }
                n2 = 0;
            }
            if (n2 != 0 && stringBuilder.charAt(n16 - 1) == '.') {
                n2 = 0;
            }
            if (n2 == 0) {
                int n17 = 6488098;
                String string = MessageHandler.getMessage(n17, new String(byArray), stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n17);
            }
        } else if (StaticUtils.isDigit(stringBuilder.charAt(0)) && !bl) {
            n2 = 6488096;
            String string = MessageHandler.getMessage(n2, new String(byArray), Character.valueOf(stringBuilder.charAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n2);
        }
        return n;
    }

    public static int parseAttributeName(String string, int n, StringBuilder stringBuilder, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeName", String.valueOf(string), String.valueOf(n), "java.lang.StringBuilder"));
        int n2 = string.length();
        if (n < n2) {
            while (string.charAt(n) == ' ') {
                if (++n != n2) continue;
                int n3 = 6488090;
                String string2 = MessageHandler.getMessage(n3, string);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n3);
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case ' ': {
                    bl3 = true;
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': {
                    int n11 = 6488092;
                    String string10 = MessageHandler.getMessage(n11, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string10, n11);
                }
                case '-': {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(c);
                        break;
                    }
                    int n12 = 6488094;
                    String string11 = MessageHandler.getMessage(n12, string, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string11, n12);
                }
                case '.': {
                    stringBuilder.append(c);
                    bl2 = true;
                    break;
                }
                case '/': {
                    int n13 = 6488092;
                    String string12 = MessageHandler.getMessage(n13, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string12, n13);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    stringBuilder.append(c);
                    break;
                }
                case ':': 
                case ';': 
                case '<': {
                    int string13 = 6488092;
                    String n15 = MessageHandler.getMessage(string13, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, n15, string13);
                }
                case '=': {
                    bl3 = true;
                    break;
                }
                case '>': 
                case '?': 
                case '@': {
                    int n14 = 6488092;
                    String string2 = MessageHandler.getMessage(n14, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n14);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    stringBuilder.append(c);
                    break;
                }
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    int string15 = 6488092;
                    String string3 = MessageHandler.getMessage(string15, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, string15);
                }
                case '_': {
                    if (stringBuilder.length() == 0) {
                        int n3 = 6488095;
                        String string4 = MessageHandler.getMessage(n3, string, "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n3);
                    }
                    if (bl) {
                        stringBuilder.append(c);
                        break;
                    }
                    int n4 = 6488093;
                    String string5 = MessageHandler.getMessage(n4, string, "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n4);
                }
                case '`': {
                    int n5 = 6488092;
                    String string6 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string6, n5);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    int n6 = 6488092;
                    String string7 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string7, n6);
                }
            }
            if (bl3) break;
            ++n;
        }
        if (stringBuilder.length() == 0) {
            int n7 = 6488097;
            String string8 = MessageHandler.getMessage(n7, string);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string8, n7);
        }
        if (bl2) {
            boolean bl4;
            boolean bl5;
            boolean bl6 = true;
            int n8 = 0;
            int n9 = stringBuilder.length();
            char c = stringBuilder.charAt(0);
            if (c == 'o' || c == 'O') {
                if (n9 <= 4) {
                    boolean bl7 = false;
                } else {
                    c = stringBuilder.charAt(1);
                    if (!(c != 'i' && c != 'I' || (c = stringBuilder.charAt(2)) != 'd' && c != 'D' || stringBuilder.charAt(3) != '.')) {
                        stringBuilder.delete(0, 4);
                        n9 -= 4;
                    } else {
                        boolean bl8 = false;
                    }
                }
            }
            while (bl5 && n8 < n9) {
                if (StaticUtils.isDigit(c = stringBuilder.charAt(n8++))) {
                    while (bl5 && n8 < n9 && StaticUtils.isDigit(stringBuilder.charAt(n8))) {
                        ++n8;
                    }
                    if (n8 >= n9 || stringBuilder.charAt(n8) == '.') continue;
                    bl5 = false;
                    continue;
                }
                if (c == '.') {
                    if (n8 != 1 && stringBuilder.charAt(n8 - 2) != '.') continue;
                    bl5 = false;
                    continue;
                }
                bl5 = false;
            }
            if (bl5 && stringBuilder.charAt(n9 - 1) == '.') {
                bl4 = false;
            }
            if (!bl4) {
                int n10 = 6488098;
                String string9 = MessageHandler.getMessage(n10, string, stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string9, n10);
            }
        } else if (StaticUtils.isDigit(stringBuilder.charAt(0)) && !bl) {
            int n11 = 6488096;
            String string10 = MessageHandler.getMessage(n11, string, Character.valueOf(stringBuilder.charAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string10, n11);
        }
        return n;
    }

    public static int parseAttributeValue(byte[] byArray, int n, ByteString byteString) throws DirectoryException {
        int n2;
        byte by;
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeValue", String.valueOf(byArray), String.valueOf(n), "java.lang.StringBuilder"));
        int n3 = byArray.length;
        if (n >= n3) {
            byteString.setValue("");
            return n;
        }
        if ((by = byArray[n++]) == 35) {
            int n4;
            StringBuilder stringBuilder = new StringBuilder();
            if (n + 2 > n3) {
                int n5 = 6488102;
                String string = MessageHandler.getMessage(n5, new String(byArray));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n5);
            }
            for (n4 = 0; n4 < 2; ++n4) {
                if (!StaticUtils.isHexDigit(by = byArray[n++])) {
                    int n6 = 6488103;
                    String string = MessageHandler.getMessage(n6, new String(byArray), Character.valueOf((char)by));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n6);
                }
                stringBuilder.append((char)by);
            }
            while (n < n3) {
                if (StaticUtils.isHexDigit(by = byArray[n++])) {
                    stringBuilder.append((char)by);
                    if (n < n3) {
                        if (StaticUtils.isHexDigit(by = byArray[n++])) {
                            stringBuilder.append((char)by);
                            continue;
                        }
                        n4 = 6488103;
                        String string = MessageHandler.getMessage(n4, new String(byArray), Character.valueOf((char)by));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n4);
                    }
                    n4 = 6488102;
                    String string = MessageHandler.getMessage(n4, new String(byArray));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n4);
                }
                if (by == 32 || by == 44 || by == 59 || by == 43) {
                    --n;
                    break;
                }
                n4 = 6488103;
                String string = MessageHandler.getMessage(n4, new String(byArray), Character.valueOf((char)by));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n4);
            }
            try {
                byteString.setValue(StaticUtils.hexStringToByteArray(stringBuilder.toString()));
                return n;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "parseAttributeValue", exception));
                int n7 = 6488104;
                String string = MessageHandler.getMessage(n7, new String(byArray), String.valueOf(exception));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n7);
            }
        }
        if (by == 34) {
            int n8 = n;
            do {
                if (n < n3) continue;
                int n9 = 6488105;
                String string = MessageHandler.getMessage(n9, new String(byArray));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n9);
            } while (byArray[n++] != 34);
            byte[] byArray2 = new byte[n - n8 - 1];
            System.arraycopy(byArray, n8, byArray2, 0, byArray2.length);
            try {
                byteString.setValue(byArray2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "parseAttributeValue", exception));
                String string = new String(byArray2);
                byteString.setValue(string);
            }
            return n;
        }
        int n10 = n - 1;
        while (n < n3) {
            if ((by = byArray[n++]) != 44 && by != 59 && by != 43) continue;
            --n;
            break;
        }
        byte[] byArray3 = new byte[n - n10];
        System.arraycopy(byArray, n10, byArray3, 0, byArray3.length);
        boolean bl = false;
        for (n2 = byArray3.length - 1; n2 > 0 && byArray3[n2] == 32; --n2) {
            bl = true;
        }
        if (bl) {
            byte[] byArray4 = new byte[n2 + 1];
            System.arraycopy(byArray3, 0, byArray4, 0, n2 + 1);
            byArray3 = byArray4;
        }
        try {
            byteString.setValue(byArray3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "parseAttributeValue", exception));
            String string = new String(byArray3);
            byteString.setValue(string);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int parseAttributeValue(String string, int n, ByteString byteString) throws DirectoryException {
        int n2;
        boolean bl;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeValue", String.valueOf(string), String.valueOf(n), "java.lang.StringBuilder"));
        int n3 = string.length();
        if (n >= n3) {
            byteString.setValue("");
            return n;
        }
        if ((c = string.charAt(n++)) == '#') {
            int n4;
            StringBuilder stringBuilder3 = new StringBuilder();
            if (n + 2 > n3) {
                int n5 = 6488102;
                String string2 = MessageHandler.getMessage(n5, string);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n5);
            }
            for (n4 = 0; n4 < 2; ++n4) {
                if (!StaticUtils.isHexDigit(c = string.charAt(n++))) {
                    int n6 = 6488103;
                    String string3 = MessageHandler.getMessage(n6, string, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n6);
                }
                stringBuilder3.append(c);
            }
            while (n < n3) {
                if (StaticUtils.isHexDigit(c = string.charAt(n++))) {
                    stringBuilder3.append(c);
                    if (n >= n3) {
                        n4 = 6488102;
                        String string4 = MessageHandler.getMessage(n4, string);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n4);
                    }
                    if (!StaticUtils.isHexDigit(c = string.charAt(n++))) {
                        n4 = 6488103;
                        String string5 = MessageHandler.getMessage(n4, string, Character.valueOf(c));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n4);
                    }
                    stringBuilder3.append(c);
                    continue;
                }
                if (c != ' ' && c != ',' && c != ';') {
                    n4 = 6488103;
                    String string6 = MessageHandler.getMessage(n4, string, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string6, n4);
                }
                --n;
                break;
            }
            try {
                byteString.setValue(StaticUtils.hexStringToByteArray(stringBuilder3.toString()));
                return n;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "parseAttributeValue", exception));
                int n7 = 6488104;
                String string7 = MessageHandler.getMessage(n7, string, String.valueOf(exception));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string7, n7);
            }
        }
        if (c != '\"') {
            stringBuilder2 = new StringBuilder();
            stringBuilder = new StringBuilder();
            if (c == '\\') {
                bl = true;
            } else {
                bl = false;
                stringBuilder2.append(c);
            }
        } else {
            boolean bl2 = false;
            StringBuilder stringBuilder4 = new StringBuilder();
            while (true) {
                if (n >= n3) {
                    int n8 = 6488105;
                    String string8 = MessageHandler.getMessage(n8, string);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string8, n8);
                }
                c = string.charAt(n++);
                if (bl2) {
                    stringBuilder4.append(c);
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c == '\"') {
                    byteString.setValue(stringBuilder4.toString());
                    return n;
                }
                stringBuilder4.append(c);
            }
        }
        while (true) {
            if (n >= n3) {
                DN.appendHexChars(string, stringBuilder2, stringBuilder);
                break;
            }
            c = string.charAt(n++);
            if (bl) {
                if (StaticUtils.isHexDigit(c)) {
                    if (n >= n3) {
                        n2 = 6488106;
                        String string9 = MessageHandler.getMessage(n2, string);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string9, n2);
                    }
                    if (!StaticUtils.isHexDigit((char)(n2 = (int)string.charAt(n++)))) {
                        int n9 = 6488106;
                        String string10 = MessageHandler.getMessage(n9, string);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string10, n9);
                    }
                    stringBuilder.append(c);
                    stringBuilder.append((char)n2);
                } else {
                    DN.appendHexChars(string, stringBuilder2, stringBuilder);
                    stringBuilder2.append(c);
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == ',' || c == ';') {
                DN.appendHexChars(string, stringBuilder2, stringBuilder);
                --n;
                break;
            }
            if (c == '+') {
                DN.appendHexChars(string, stringBuilder2, stringBuilder);
                --n;
                break;
            }
            DN.appendHexChars(string, stringBuilder2, stringBuilder);
            stringBuilder2.append(c);
        }
        if (n > 2 && string.charAt(n - 1) == ' ' && string.charAt(n - 2) != '\\') {
            for (n2 = stringBuilder2.length() - 1; n2 > 0 && stringBuilder2.charAt(n2) == ' '; --n2) {
                stringBuilder2.delete(n2, n2 + '\u0001');
            }
        }
        byteString.setValue(stringBuilder2.toString());
        return n;
    }

    public static void appendHexChars(String string, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws DirectoryException {
        try {
            byte[] byArray = StaticUtils.hexStringToByteArray(stringBuilder2.toString());
            stringBuilder.append(new String(byArray, "UTF-8"));
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "appendHexChars", exception));
            int n = 6488104;
            String string2 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n);
        }
    }

    public DN duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        RDN[] rDNArray = new RDN[this.numComponents];
        for (int i = 0; i < this.numComponents; ++i) {
            rDNArray[i] = this.rdnComponents[i].duplicate();
        }
        return new DN(rDNArray);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            return this.normalizedDN.equals(((DN)object).normalizedDN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "equals", exception));
            return false;
        }
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.normalizedDN.hashCode();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        if (this.dnString == null) {
            if (this.numComponents == 0) {
                this.dnString = "";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                this.rdnComponents[0].toString(stringBuilder);
                for (int i = 1; i < this.numComponents; ++i) {
                    stringBuilder.append(",");
                    this.rdnComponents[i].toString(stringBuilder);
                }
                this.dnString = stringBuilder.toString();
            }
        }
        return this.dnString;
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append(this.toString());
    }

    public String toNormalizedString() {
        assert (Debug.debugEnter(CLASS_NAME, "toNormalizedString", new String[0]));
        if (this.normalizedDN == null) {
            if (this.numComponents == 0) {
                this.normalizedDN = "";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                this.rdnComponents[0].toNormalizedString(stringBuilder);
                for (int i = 1; i < this.numComponents; ++i) {
                    stringBuilder.append(',');
                    this.rdnComponents[i].toNormalizedString(stringBuilder);
                }
                this.normalizedDN = stringBuilder.toString();
            }
        }
        return this.normalizedDN;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toNormalizedString", "java.lang.StringBuilder"));
        stringBuilder.append(this.toNormalizedString());
    }

    @Override
    public int compareTo(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "compareTo", String.valueOf(dN)));
        if (this.equals(dN)) {
            return 0;
        }
        if (this.isNullDN()) {
            return -1;
        }
        if (dN.isNullDN()) {
            return 1;
        }
        if (this.isAncestorOf(dN)) {
            return -1;
        }
        if (this.isDescendantOf(dN)) {
            return 1;
        }
        int n = Math.min(this.numComponents, dN.numComponents);
        for (int i = 0; i < n; ++i) {
            RDN rDN = this.rdnComponents[this.rdnComponents.length - 1 - i];
            RDN rDN2 = dN.rdnComponents[dN.rdnComponents.length - 1 - i];
            int n2 = rDN.compareTo(rDN2);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }
}

