/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Comparator;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DN;
import org.opends.server.types.RDN;
import org.opends.server.types.RDNComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNComparator
implements Comparator<DN> {
    private static final String CLASS_NAME = "org.opends.server.types.DNComparator";
    private RDNComparator rdnComparator;

    public DNComparator() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.rdnComparator = new RDNComparator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(DN dN, DN dN2) {
        assert (Debug.debugEnter(CLASS_NAME, "compare", String.valueOf(dN), String.valueOf(dN2)));
        RDN[] rDNArray = dN.getRDNComponents();
        RDN[] rDNArray2 = dN2.getRDNComponents();
        int n = rDNArray.length - 1;
        int n2 = rDNArray2.length - 1;
        while (true) {
            if (n >= 0) {
                if (n2 < 0) return 1;
                int n3 = this.rdnComparator.compare(rDNArray[n], rDNArray2[n2]);
                if (n3 != 0) {
                    return n3;
                }
            } else {
                if (n2 < 0) return 0;
                return -1;
            }
            --n;
            --n2;
        }
    }
}

