/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDN
implements Comparable<RDN> {
    private static final String CLASS_NAME = "org.opends.server.types.RDN";
    private AttributeType[] attributeTypes;
    private AttributeValue[] attributeValues;
    private int numValues;
    private String normalizedRDN;
    private String rdnString;
    private String[] attributeNames;

    public RDN(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(attributeValue)));
        this.attributeTypes = new AttributeType[]{attributeType};
        this.attributeNames = new String[]{attributeType.getPrimaryName()};
        this.attributeValues = new AttributeValue[]{attributeValue};
        this.numValues = 1;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public RDN(AttributeType attributeType, String string, AttributeValue attributeValue) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(string), String.valueOf(attributeValue)));
        this.attributeTypes = new AttributeType[]{attributeType};
        this.attributeNames = new String[]{string};
        this.attributeValues = new AttributeValue[]{attributeValue};
        this.numValues = 1;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public RDN(List<AttributeType> list, List<String> list2, List<AttributeValue> list3) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(list), String.valueOf(list2), String.valueOf(list3)));
        this.attributeTypes = new AttributeType[list.size()];
        this.attributeNames = new String[list2.size()];
        this.attributeValues = new AttributeValue[list3.size()];
        list.toArray(this.attributeTypes);
        list2.toArray(this.attributeNames);
        list3.toArray(this.attributeValues);
        this.numValues = list.size();
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public RDN(AttributeType[] attributeTypeArray, String[] stringArray, AttributeValue[] attributeValueArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeTypeArray), String.valueOf(stringArray), String.valueOf(attributeValueArray)));
        this.numValues = attributeTypeArray.length;
        this.attributeTypes = attributeTypeArray;
        this.attributeNames = stringArray;
        this.attributeValues = attributeValueArray;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public int getNumValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getNumValues", new String[0]));
        return this.numValues;
    }

    public AttributeType[] getAttributeTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeTypes", new String[0]));
        return this.attributeTypes;
    }

    public boolean hasAttributeType(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAttributeType", String.valueOf(attributeType)));
        for (AttributeType attributeType2 : this.attributeTypes) {
            if (!attributeType2.equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAttributeType", String.valueOf(string)));
        for (AttributeType object : this.attributeTypes) {
            if (!object.hasNameOrOID(string)) continue;
            return true;
        }
        for (String string2 : this.attributeNames) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String[] getAttributeNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeNames", new String[0]));
        return this.attributeNames;
    }

    public AttributeValue[] getAttributeValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValues", new String[0]));
        return this.attributeValues;
    }

    public AttributeValue getAttributeValue(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValue", String.valueOf(attributeType)));
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(attributeType)) continue;
            return this.attributeValues[i];
        }
        return null;
    }

    public boolean isMultiValued() {
        assert (Debug.debugEnter(CLASS_NAME, "isMultiValued", new String[0]));
        return this.numValues > 1;
    }

    public boolean hasValue(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "hasValue", String.valueOf(attributeType), String.valueOf(attributeValue)));
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(attributeType) || !this.attributeValues[i].equals(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean addValue(AttributeType attributeType, String string, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "addValue", String.valueOf(attributeType), String.valueOf(string), String.valueOf(attributeValue)));
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(attributeType) || !this.attributeValues[i].equals(attributeValue)) continue;
            return false;
        }
        ++this.numValues;
        AttributeType[] attributeTypeArray = new AttributeType[this.numValues];
        System.arraycopy(this.attributeTypes, 0, attributeTypeArray, 0, this.attributeTypes.length);
        attributeTypeArray[this.attributeTypes.length] = attributeType;
        this.attributeTypes = attributeTypeArray;
        String[] stringArray = new String[this.numValues];
        System.arraycopy(this.attributeNames, 0, stringArray, 0, this.attributeNames.length);
        stringArray[this.attributeNames.length] = string;
        this.attributeNames = stringArray;
        AttributeValue[] attributeValueArray = new AttributeValue[this.numValues];
        System.arraycopy(this.attributeValues, 0, attributeValueArray, 0, this.attributeValues.length);
        attributeValueArray[this.attributeValues.length] = attributeValue;
        this.attributeValues = attributeValueArray;
        this.rdnString = null;
        this.normalizedRDN = null;
        return true;
    }

    public boolean removeValue(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "removeValue", String.valueOf(attributeType), String.valueOf(attributeValue)));
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(attributeType) || !this.attributeValues[i].equals(attributeValue)) continue;
            --this.numValues;
            if (this.numValues == 0) {
                this.attributeTypes = new AttributeType[0];
                this.attributeNames = new String[0];
                this.attributeValues = new AttributeValue[0];
            } else if (i == 0) {
                AttributeType[] attributeTypeArray = new AttributeType[this.numValues];
                System.arraycopy(this.attributeTypes, 1, attributeTypeArray, 0, this.numValues);
                this.attributeTypes = attributeTypeArray;
                String[] stringArray = new String[this.numValues];
                System.arraycopy(this.attributeNames, 1, stringArray, 0, this.numValues);
                this.attributeNames = stringArray;
                AttributeValue[] attributeValueArray = new AttributeValue[this.numValues];
                System.arraycopy(this.attributeValues, 1, attributeValueArray, 0, this.numValues);
                this.attributeValues = attributeValueArray;
            } else if (i == this.numValues) {
                AttributeType[] attributeTypeArray = new AttributeType[this.numValues];
                System.arraycopy(this.attributeTypes, 0, attributeTypeArray, 0, this.numValues);
                this.attributeTypes = attributeTypeArray;
                String[] stringArray = new String[this.numValues];
                System.arraycopy(this.attributeNames, 0, stringArray, 0, this.numValues);
                this.attributeNames = stringArray;
                AttributeValue[] attributeValueArray = new AttributeValue[this.numValues];
                System.arraycopy(this.attributeValues, 0, attributeValueArray, 0, this.numValues);
                this.attributeValues = attributeValueArray;
            } else {
                int n = this.numValues - i;
                AttributeType[] attributeTypeArray = new AttributeType[this.numValues];
                System.arraycopy(this.attributeTypes, 0, attributeTypeArray, 0, i);
                System.arraycopy(this.attributeTypes, i + 1, attributeTypeArray, i, n);
                this.attributeTypes = attributeTypeArray;
                String[] stringArray = new String[this.numValues];
                System.arraycopy(this.attributeNames, 0, stringArray, 0, i);
                System.arraycopy(this.attributeNames, i + 1, stringArray, i, n);
                this.attributeNames = stringArray;
                AttributeValue[] attributeValueArray = new AttributeValue[this.numValues];
                System.arraycopy(this.attributeValues, 0, attributeValueArray, 0, i);
                System.arraycopy(this.attributeValues, i + 1, attributeValueArray, i, n);
                this.attributeValues = attributeValueArray;
            }
            this.rdnString = null;
            this.normalizedRDN = null;
            return true;
        }
        return false;
    }

    public void replaceValues(AttributeType attributeType, String string, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "replaceValues", String.valueOf(attributeType), String.valueOf(string), String.valueOf(attributeValue)));
        this.attributeTypes = new AttributeType[]{attributeType};
        this.attributeNames = new String[]{string};
        this.attributeValues = new AttributeValue[]{attributeValue};
        this.numValues = 1;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public void replaceValues(ArrayList<AttributeType> arrayList, ArrayList<String> arrayList2, ArrayList<AttributeValue> arrayList3) {
        assert (Debug.debugEnter(CLASS_NAME, "replaceValues", String.valueOf(arrayList), String.valueOf(arrayList2), String.valueOf(arrayList3)));
        this.attributeTypes = new AttributeType[arrayList.size()];
        arrayList.toArray(this.attributeTypes);
        this.attributeNames = new String[arrayList2.size()];
        arrayList2.toArray(this.attributeNames);
        this.attributeValues = new AttributeValue[arrayList3.size()];
        arrayList3.toArray(this.attributeValues);
        this.numValues = arrayList.size();
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public static RDN decode(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        if (string == null) {
            int n = 196779;
            String string2 = MessageHandler.getMessage(n);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n);
        }
        int n = string.length();
        if (n == 0) {
            int n2 = 196779;
            String string3 = MessageHandler.getMessage(n2);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n2);
        }
        int n3 = 0;
        char c = string.charAt(n3);
        while (c == ' ') {
            if (++n3 == n) {
                int n4 = 196779;
                String string4 = MessageHandler.getMessage(n4);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n4);
            }
            c = string.charAt(n3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = DirectoryServer.allowAttributeNameExceptions();
        if ((n3 = DN.parseAttributeName(string, n3, stringBuilder, bl)) >= n) {
            int n5 = 196780;
            String string5 = MessageHandler.getMessage(n5, string, stringBuilder.toString());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n5);
        }
        c = string.charAt(n3);
        while (c == ' ') {
            if (++n3 >= n) {
                int n6 = 196780;
                String string6 = MessageHandler.getMessage(n6, string, stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string6, n6);
            }
            c = string.charAt(n3);
        }
        if (c == '=') {
            ++n3;
        } else {
            int n7 = 196781;
            String string7 = MessageHandler.getMessage(n7, string, stringBuilder.toString(), Character.valueOf(c), n3);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string7, n7);
        }
        while (n3 < n && (c = string.charAt(n3)) == ' ') {
            ++n3;
        }
        if (n3 >= n) {
            String string8 = stringBuilder.toString();
            String string9 = StaticUtils.toLowerCase(string8);
            AttributeType attributeType = DirectoryServer.getAttributeType(string9);
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(string8);
            }
            AttributeValue attributeValue = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
            return new RDN(attributeType, string8, attributeValue);
        }
        ASN1OctetString aSN1OctetString = new ASN1OctetString();
        n3 = DN.parseAttributeValue(string, n3, (ByteString)aSN1OctetString);
        String string10 = stringBuilder.toString();
        String string11 = StaticUtils.toLowerCase(string10);
        AttributeType attributeType = DirectoryServer.getAttributeType(string11);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string10);
        }
        AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
        RDN rDN = new RDN(attributeType, string10, attributeValue);
        while (n3 < n && (c = string.charAt(n3)) == ' ') {
            ++n3;
        }
        if (n3 >= n) {
            return rDN;
        }
        if (c == ',' || c == ';') {
            int n8 = 196782;
            String string12 = MessageHandler.getMessage(n8, string, n3);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string12, n8);
        }
        if (c != '+') {
            int n9 = 196783;
            String string13 = MessageHandler.getMessage(n9, string, Character.valueOf(c), n3);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string13, n9);
        }
        do {
            ++n3;
            while (n3 < n && (c = string.charAt(n3)) == ' ') {
                ++n3;
            }
            stringBuilder = new StringBuilder();
            if ((n3 = DN.parseAttributeName(string, n3, stringBuilder, bl)) >= n) {
                int n10 = 196780;
                String string14 = MessageHandler.getMessage(n10, string, stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string14, n10);
            }
            c = string.charAt(n3);
            while (c == ' ') {
                if (++n3 >= n) {
                    int n11 = 196780;
                    String string15 = MessageHandler.getMessage(n11, string, stringBuilder.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string15, n11);
                }
                c = string.charAt(n3);
            }
            if (c == '=') {
                ++n3;
            } else {
                int n12 = 196781;
                String string16 = MessageHandler.getMessage(n12, string, stringBuilder.toString(), Character.valueOf(c), n3);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string16, n12);
            }
            while (n3 < n && (c = string.charAt(n3)) == ' ') {
                ++n3;
            }
            if (n3 >= n) {
                string10 = stringBuilder.toString();
                string11 = StaticUtils.toLowerCase(string10);
                attributeType = DirectoryServer.getAttributeType(string11);
                if (attributeType == null) {
                    attributeType = DirectoryServer.getDefaultAttributeType(string10);
                }
                attributeValue = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                rDN.addValue(attributeType, string10, attributeValue);
                return rDN;
            }
            aSN1OctetString = new ASN1OctetString();
            n3 = DN.parseAttributeValue(string, n3, (ByteString)aSN1OctetString);
            string10 = stringBuilder.toString();
            string11 = StaticUtils.toLowerCase(string10);
            attributeType = DirectoryServer.getAttributeType(string11);
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(string10);
            }
            attributeValue = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
            rDN.addValue(attributeType, string10, attributeValue);
            while (n3 < n && (c = string.charAt(n3)) == ' ') {
                ++n3;
            }
            if (n3 >= n) {
                return rDN;
            }
            if (c != ',' && c != ';') continue;
            int n13 = 196782;
            String string17 = MessageHandler.getMessage(n13, string, n3);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string17, n13);
        } while (c == '+');
        int n14 = 196783;
        String string18 = MessageHandler.getMessage(n14, string, Character.valueOf(c), n3);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string18, n14);
    }

    public RDN duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        AttributeType[] attributeTypeArray = new AttributeType[this.numValues];
        System.arraycopy(this.attributeTypes, 0, attributeTypeArray, 0, this.numValues);
        String[] stringArray = new String[this.numValues];
        System.arraycopy(this.attributeNames, 0, stringArray, 0, this.numValues);
        AttributeValue[] attributeValueArray = new AttributeValue[this.numValues];
        System.arraycopy(this.attributeValues, 0, attributeValueArray, 0, this.numValues);
        return new RDN(attributeTypeArray, stringArray, attributeValueArray);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        if (this.numValues != rDN.numValues) {
            return false;
        }
        for (int i = 0; i < this.numValues; ++i) {
            if (this.attributeTypes[i].equals(rDN.attributeTypes[i]) && this.attributeValues[i].equals(rDN.attributeValues[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = 0;
        for (int i = 0; i < this.numValues; ++i) {
            n += this.attributeTypes[i].hashCode() + this.attributeValues[i].hashCode();
        }
        return n;
    }

    public String toString() {
        if (this.rdnString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.attributeNames[0]);
            stringBuilder.append("=");
            stringBuilder.append(this.attributeValues[0].getDNStringValue());
            for (int i = 1; i < this.numValues; ++i) {
                stringBuilder.append("+");
                stringBuilder.append(this.attributeNames[i]);
                stringBuilder.append("=");
                stringBuilder.append(this.attributeValues[i].getDNStringValue());
            }
            this.rdnString = stringBuilder.toString();
        }
        return this.rdnString;
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append(this.toString());
    }

    public String toNormalizedString() {
        if (this.normalizedRDN == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toNormalizedString(stringBuilder);
        }
        return this.normalizedRDN;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        boolean bl;
        assert (Debug.debugEnter(CLASS_NAME, "toNormalizedString", "java.lang.StringBuilder"));
        if (this.normalizedRDN != null) {
            stringBuilder.append(this.normalizedRDN);
            return;
        }
        boolean bl2 = bl = stringBuilder.length() == 0;
        if (this.attributeNames.length == 1) {
            StaticUtils.toLowerCase(this.attributeNames[0], stringBuilder);
            stringBuilder.append('=');
            try {
                stringBuilder.append(this.attributeValues[0].getNormalizedDNStringValue());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "toNormalizedString", exception));
                stringBuilder.append(this.attributeValues[0].getStringValue());
            }
        } else {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < this.attributeNames.length; ++i) {
                StringBuilder stringBuilder2 = new StringBuilder();
                StaticUtils.toLowerCase(this.attributeNames[i], stringBuilder2);
                stringBuilder2.append('=');
                try {
                    stringBuilder2.append(this.attributeValues[i].getNormalizedStringValue());
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "toNormalizedString", exception));
                    stringBuilder2.append(this.attributeValues[i].getStringValue());
                }
                treeSet.add(stringBuilder2.toString());
            }
            Iterator iterator = treeSet.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append('+');
                stringBuilder.append((String)iterator.next());
            }
        }
        if (bl) {
            this.normalizedRDN = stringBuilder.toString();
        }
    }

    @Override
    public int compareTo(RDN rDN) {
        assert (Debug.debugEnter(CLASS_NAME, "compareTo", String.valueOf(rDN)));
        if (this.equals(rDN)) {
            return 0;
        }
        int n = Math.min(this.numValues, rDN.numValues);
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = this.attributeNames[i].toLowerCase();
            int n2 = string2.compareTo(string = rDN.attributeNames[i].toLowerCase());
            if (n2 != 0) {
                return n2;
            }
            try {
                String string3 = this.attributeValues[i].getNormalizedStringValue();
                String string4 = rDN.attributeValues[i].getNormalizedStringValue();
                n2 = string3.compareTo(string4);
                if (n2 == 0) continue;
                return n2;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "compareTo", exception));
                return 0;
            }
        }
        if (this.numValues > n) {
            return 1;
        }
        if (rDN.numValues > n) {
            return -1;
        }
        return 0;
    }
}

