/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMailMessage {
    private static final String CLASS_NAME = "org.opends.server.util.EMailMessage";
    private ArrayList<String> recipients;
    private LinkedList<MimeBodyPart> attachments;
    private String bodyMIMEType;
    private String sender;
    private String subject;
    private StringBuilder body;

    public EMailMessage(String string, String string2, String string3) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(string3)));
        this.sender = string;
        this.subject = string3;
        this.recipients = new ArrayList();
        this.recipients.add(string2);
        this.body = new StringBuilder();
        this.attachments = new LinkedList();
        this.bodyMIMEType = "text/plain";
    }

    public EMailMessage(String string, ArrayList<String> arrayList, String string2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(arrayList), String.valueOf(string2)));
        this.sender = string;
        this.recipients = arrayList;
        this.subject = string2;
        this.body = new StringBuilder();
    }

    public String getSender() {
        assert (Debug.debugEnter(CLASS_NAME, "getSender", new String[0]));
        return this.sender;
    }

    public void setSender(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSender", String.valueOf(string)));
        this.sender = string;
    }

    public ArrayList<String> getRecipients() {
        assert (Debug.debugEnter(CLASS_NAME, "getRecipients", new String[0]));
        return this.recipients;
    }

    public void setRecipients(ArrayList<String> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "setRecipients", String.valueOf(arrayList)));
        this.recipients = arrayList;
    }

    public void addRecipient(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addRecipient", String.valueOf(string)));
        this.recipients.add(string);
    }

    public String getSubject() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubject", new String[0]));
        return this.subject;
    }

    public void setSubject(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubject", String.valueOf(string)));
        this.subject = string;
    }

    public StringBuilder getBody() {
        assert (Debug.debugEnter(CLASS_NAME, "getBody", new String[0]));
        return this.body;
    }

    public void setBody(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "setBody", String.valueOf(stringBuilder)));
        this.body = stringBuilder;
    }

    public void setBody(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setBody", String.valueOf(string)));
        this.body = new StringBuilder(string);
    }

    public void appendToBody(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "appendToBody", String.valueOf(string)));
        this.body.append(string);
    }

    public LinkedList<MimeBodyPart> getAttachments() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttachments", new String[0]));
        return this.attachments;
    }

    public void addAttachment(MimeBodyPart mimeBodyPart) {
        assert (Debug.debugEnter(CLASS_NAME, "addAttachment", String.valueOf(mimeBodyPart)));
        this.attachments.add(mimeBodyPart);
    }

    public void addAttachment(String string) throws MessagingException {
        assert (Debug.debugEnter(CLASS_NAME, "addAttachment", String.valueOf(string)));
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string);
        this.attachments.add(mimeBodyPart);
    }

    public void addAttachment(File file) throws MessagingException {
        assert (Debug.debugEnter(CLASS_NAME, "addAttachment", String.valueOf(file)));
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        FileDataSource fileDataSource = new FileDataSource(file);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
        this.attachments.add(mimeBodyPart);
    }

    public void send() throws MessagingException {
        assert (Debug.debugEnter(CLASS_NAME, "send", new String[0]));
        SendFailedException sendFailedException = null;
        for (Properties object : DirectoryServer.getMailServerPropertySets()) {
            String string;
            Session session = Session.getInstance((Properties)object);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSubject(this.subject);
            mimeMessage.setSentDate(new Date());
            try {
                mimeMessage.setFrom((Address)new InternetAddress(this.sender));
            }
            catch (MessagingException messagingException) {
                assert (Debug.debugException(CLASS_NAME, "send", messagingException));
                int i = 5505100;
                string = MessageHandler.getMessage(i, String.valueOf(this.sender), messagingException.getMessage());
                throw new MessagingException(string, (Exception)((Object)messagingException));
            }
            InternetAddress[] messagingException = new InternetAddress[this.recipients.size()];
            for (int mimeMultipart = 0; mimeMultipart < messagingException.length; ++mimeMultipart) {
                string = this.recipients.get(mimeMultipart);
                try {
                    messagingException[mimeMultipart] = new InternetAddress(string);
                    continue;
                }
                catch (MessagingException messagingException2) {
                    assert (Debug.debugException(CLASS_NAME, "send", messagingException2));
                    int n = 5505101;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(string), messagingException2.getMessage());
                    throw new MessagingException(string2, (Exception)((Object)messagingException2));
                }
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])messagingException);
            if (this.attachments.isEmpty()) {
                mimeMessage.setText(this.body.toString());
            } else {
                MimeMultipart sendFailedException2 = new MimeMultipart();
                string = new MimeBodyPart();
                string.setText(this.body.toString());
                sendFailedException2.addBodyPart((BodyPart)string);
                for (MimeBodyPart n : this.attachments) {
                    sendFailedException2.addBodyPart((BodyPart)n);
                }
            }
            try {
                Transport.send((Message)mimeMessage);
            }
            catch (SendFailedException sendFailedException2) {
                assert (Debug.debugException(CLASS_NAME, "send", sendFailedException2));
                if (sendFailedException != null) continue;
                sendFailedException = sendFailedException2;
            }
        }
        if (sendFailedException == null) {
            int n = 5505102;
            String string = MessageHandler.getMessage(n);
            throw new MessagingException(string);
        }
        throw sendFailedException;
    }
}

