/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import org.opends.server.messages.MessageHandler;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

public class IntegerArgument
extends Argument {
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private int lowerBound;
    private int upperBound;

    public IntegerArgument(String string, Character c, String string2, boolean bl, boolean bl2, String string3, int n, Object ... objectArray) throws ArgumentException {
        super(string, c, string2, bl, false, bl2, string3, null, null, n, objectArray);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String string, Character c, String string2, boolean bl, boolean bl2, String string3, boolean bl3, int n, boolean bl4, int n2, int n3, Object ... objectArray) throws ArgumentException {
        super(string, c, string2, bl, false, bl2, string3, null, null, n3, objectArray);
        this.hasLowerBound = bl3;
        this.hasUpperBound = bl4;
        this.lowerBound = n;
        this.upperBound = n2;
        if (bl3 && bl4 && n > n2) {
            int n4 = 5505067;
            String string4 = MessageHandler.getMessage(n4, string, n, n2);
            throw new ArgumentException(n4, string4);
        }
    }

    public IntegerArgument(String string, Character c, String string2, boolean bl, boolean bl2, boolean bl3, String string3, int n, String string4, int n2, Object ... objectArray) throws ArgumentException {
        super(string, c, string2, bl, bl2, bl3, string3, String.valueOf(n), string4, n2, objectArray);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String string, Character c, String string2, boolean bl, boolean bl2, boolean bl3, String string3, int n, String string4, boolean bl4, int n2, boolean bl5, int n3, int n4, Object ... objectArray) throws ArgumentException {
        super(string, c, string2, bl, bl2, bl3, string3, String.valueOf(n), string4, n4, objectArray);
        this.hasLowerBound = bl4;
        this.hasUpperBound = bl5;
        this.lowerBound = n2;
        this.upperBound = n3;
        if (bl4 && bl5 && n2 > n3) {
            int n5 = 5505067;
            String string5 = MessageHandler.getMessage(n5, string, n2, n3);
            throw new ArgumentException(n5, string5);
        }
    }

    public boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean valueIsAcceptable(String string, StringBuilder stringBuilder) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            int n2 = 5505062;
            stringBuilder.append(MessageHandler.getMessage(n2, string, this.getName()));
            return false;
        }
        if (this.hasLowerBound && n < this.lowerBound) {
            int n3 = 5505068;
            stringBuilder.append(MessageHandler.getMessage(n3, this.getName(), n, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && n > this.upperBound) {
            int n4 = 5505069;
            stringBuilder.append(MessageHandler.getMessage(n4, this.getName(), n, this.upperBound));
            return false;
        }
        return true;
    }
}

