/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.support;

import com.sun.xacml.ConfigurationStore;
import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import com.sun.xacml.finder.impl.SelectorModule;
import com.sun.xacml.support.finder.StaticPolicyFinderModule;
import com.sun.xacml.support.finder.StaticRefPolicyFinderModule;
import com.sun.xacml.support.finder.URLPolicyFinderModule;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SimplePDP {
    private PDP pdp = null;

    public SimplePDP() throws Exception {
        ConfigurationStore store = new ConfigurationStore();
        store.useDefaultFactories();
        this.pdp = new PDP(store.getDefaultPDPConfig());
    }

    public SimplePDP(String[] policies) throws Exception {
        List<String> policyList = Arrays.asList(policies);
        StaticPolicyFinderModule staticModule = new StaticPolicyFinderModule("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides", policyList);
        StaticRefPolicyFinderModule staticRefModule = new StaticRefPolicyFinderModule(policyList);
        URLPolicyFinderModule urlModule = new URLPolicyFinderModule();
        PolicyFinder policyFinder = new PolicyFinder();
        HashSet<PolicyFinderModule> policyModules = new HashSet<PolicyFinderModule>();
        policyModules.add(staticModule);
        policyModules.add(staticRefModule);
        policyModules.add(urlModule);
        policyFinder.setModules(policyModules);
        CurrentEnvModule envAttributeModule = new CurrentEnvModule();
        SelectorModule selectorAttributeModule = new SelectorModule();
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<Object> attributeModules = new ArrayList<Object>();
        attributeModules.add(envAttributeModule);
        attributeModules.add(selectorAttributeModule);
        attributeFinder.setModules(attributeModules);
        this.pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
    }

    public ResponseCtx evaluate(String requestFile) throws IOException, ParsingException {
        RequestCtx request = RequestCtx.getInstance((InputStream)new FileInputStream(requestFile));
        return this.pdp.evaluate(request);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: -config <request>");
            System.out.println("       <request> <policy> [policies]");
            System.exit(1);
        }
        SimplePDP simplePDP = null;
        String requestFile = null;
        if (args[0].equals("-config")) {
            requestFile = args[1];
            simplePDP = new SimplePDP();
        } else {
            requestFile = args[0];
            String[] policyFiles = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                policyFiles[i - 1] = args[i];
            }
            simplePDP = new SimplePDP(policyFiles);
        }
        ResponseCtx response = simplePDP.evaluate(requestFile);
        response.encode((OutputStream)System.out, new Indenter());
    }
}

