/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.editor;

import java.util.Vector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.MultiPageKeyBindingEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class FormEditor
extends MultiPageEditorPart {
    private FormToolkit toolkit;
    protected Vector pages = new Vector();
    private IEditorPart sourcePage;
    private IEditorPart lastActiveEditor = null;
    private int currentPage = -1;

    protected void createPages() {
        this.toolkit = this.createToolkit(this.getContainer().getDisplay());
        this.addPages();
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(display);
    }

    protected abstract void addPages();

    protected IEditorSite createSite(IEditorPart editor) {
        return new MultiPageKeyBindingEditorSite(this, editor);
    }

    public int addPage(IFormPage page) throws PartInitException {
        int i = this.addPage(page.getPartControl());
        this.configurePage(i, page);
        return i;
    }

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        int index = super.addPage(editor, input);
        if (editor instanceof IFormPage) {
            this.configurePage(index, (IFormPage)editor);
        }
        return index;
    }

    protected void configurePage(int index, IFormPage page) throws PartInitException {
        this.setPageText(index, page.getTitle());
        page.setIndex(index);
        this.registerPage(page);
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage page = (IFormPage)this.pages.get(i);
            if (!page.isSource()) {
                page.dispose();
            }
            ++i;
        }
        this.pages = null;
        this.toolkit.dispose();
        this.toolkit = null;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    protected void pageChange(int newPageIndex) {
        IFormPage page;
        if (this.lastActiveEditor != null) {
            ((MultiPageKeyBindingEditorSite)this.lastActiveEditor.getSite()).deactivate();
            this.lastActiveEditor = null;
        }
        if ((page = (IFormPage)this.pages.get(newPageIndex)).getPartControl() == null) {
            page.createPartControl(this.getContainer());
            this.setControl(newPageIndex, page.getPartControl());
        }
        int oldPage = this.getCurrentPage();
        if (this.pages.size() > newPageIndex && this.pages.get(newPageIndex) instanceof IFormPage) {
            ((IFormPage)this.pages.get(newPageIndex)).setActive(true);
        }
        if (oldPage != -1 && this.pages.size() > oldPage && this.pages.get(oldPage) instanceof IFormPage) {
            ((IFormPage)this.pages.get(oldPage)).setActive(false);
        }
        super.pageChange(newPageIndex);
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null && activeEditor.getSite() instanceof MultiPageKeyBindingEditorSite) {
            ((MultiPageKeyBindingEditorSite)activeEditor.getSite()).activate();
            this.lastActiveEditor = activeEditor;
        }
        this.currentPage = newPageIndex;
    }

    public IFormPage setActivePage(String pageId) {
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage page = (IFormPage)this.pages.get(i);
            if (page.getId().equals(pageId)) {
                this.setActivePage(i);
                return page;
            }
            ++i;
        }
        return null;
    }

    public IFormPage findPage(String pageId) {
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage page = (IFormPage)this.pages.get(i);
            if (page.getId().equals(pageId)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public IFormPage setActivePage(String pageId, Object pageInput) {
        IManagedForm mform;
        IFormPage page = this.setActivePage(pageId);
        if (page != null && (mform = page.getManagedForm()) != null) {
            mform.setInput(pageInput);
        }
        return page;
    }

    public IFormPage getActivePageInstance() {
        int index = this.getActivePage();
        if (index != -1) {
            return (IFormPage)this.pages.get(index);
        }
        return null;
    }

    protected void setActivePage(int pageIndex) {
        if (this.pages.size() > pageIndex && this.pages.get(pageIndex) instanceof IFormPage) {
            this.pageChange(pageIndex);
            IFormPage activePage = (IFormPage)this.pages.get(pageIndex);
            activePage.setActive(true);
            super.setActivePage(pageIndex);
        } else {
            super.setActivePage(pageIndex);
        }
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(this.getEditor(pageIndex));
        }
    }

    private void registerPage(IFormPage page) throws PartInitException {
        if (!this.pages.contains(page)) {
            this.pages.add(page);
        }
        if (!page.isSource()) {
            page.init(this.getEditorSite(), this.getEditorInput());
        }
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (FormEditor.this.toolkit != null) {
                    FormEditor.this.getSite().getPage().closeEditor((IEditorPart)FormEditor.this, save);
                }
            }
        });
    }
}

