/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.internal.widgets.HyperlinkSegment;
import org.eclipse.ui.forms.internal.widgets.Locator;
import org.eclipse.ui.forms.internal.widgets.Paragraph;

public class BulletParagraph
extends Paragraph {
    public static final int CIRCLE = 1;
    public static final int TEXT = 2;
    public static final int IMAGE = 3;
    private int style = 1;
    private String text;
    private int CIRCLE_DIAM = 5;
    private int SPACING = 10;
    private int indent = -1;
    private int bindent = -1;

    public BulletParagraph(boolean addVerticalSpace) {
        super(addVerticalSpace);
    }

    public int getIndent() {
        int ivalue = this.indent;
        if (ivalue != -1) {
            return ivalue;
        }
        switch (this.style) {
            case 1: {
                ivalue = this.CIRCLE_DIAM + this.SPACING;
                break;
            }
            default: {
                ivalue = 20;
            }
        }
        return this.getBulletIndent() + ivalue;
    }

    public int getBulletIndent() {
        if (this.bindent != -1) {
            return this.bindent;
        }
        return 0;
    }

    public int getBulletStyle() {
        return this.style;
    }

    public void setBulletStyle(int style) {
        this.style = style;
    }

    public void setBulletText(String text) {
        this.text = text;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setBulletIndent(int bindent) {
        this.bindent = bindent;
    }

    public String getBulletText() {
        return this.text;
    }

    public void paint(GC gc, int width, Locator loc, int lineHeight, Hashtable resourceTable, HyperlinkSegment selectedLink) {
        this.computeRowHeights(gc, width, loc, lineHeight, resourceTable);
        this.paintBullet(gc, loc, lineHeight, resourceTable);
        super.paint(gc, width, loc, lineHeight, resourceTable, selectedLink);
    }

    public void paintBullet(GC gc, Locator loc, int lineHeight, Hashtable resourceTable) {
        Image image;
        int x = loc.x - this.getIndent() + this.getBulletIndent();
        int rowHeight = ((int[])loc.heights.get(0))[0];
        if (this.style == 1) {
            int y = loc.y + rowHeight / 2 - this.CIRCLE_DIAM / 2;
            Color bg = gc.getBackground();
            Color fg = gc.getForeground();
            gc.setBackground(fg);
            gc.fillRectangle(x, y + 1, 5, 3);
            gc.fillRectangle(x + 1, y, 3, 5);
            gc.setBackground(bg);
        } else if (this.style == 2 && this.text != null) {
            gc.drawText(this.text, x, loc.y);
        } else if (this.style == 3 && this.text != null && (image = (Image)resourceTable.get(this.text)) != null) {
            int y = loc.y + rowHeight / 2 - image.getBounds().height / 2;
            gc.drawImage(image, x, y);
        }
    }
}

