/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.loadbalancing;

import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.net.InetSocketAddress;
import java.util.Collection;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import systems.composable.dropwizard.cassandra.loadbalancing.LoadBalancingPolicyFactory;

@JsonTypeName(value="whiteList")
public class WhiteListPolicyFactory
implements LoadBalancingPolicyFactory {
    @Valid
    @NotNull
    private LoadBalancingPolicyFactory subPolicy;
    @NotNull
    private Collection<InetSocketAddress> whiteList;

    @JsonProperty
    public LoadBalancingPolicyFactory getSubPolicy() {
        return this.subPolicy;
    }

    @JsonProperty
    public void setSubPolicy(LoadBalancingPolicyFactory subPolicy) {
        this.subPolicy = subPolicy;
    }

    @JsonProperty
    public Collection<InetSocketAddress> getWhiteList() {
        return this.whiteList;
    }

    @JsonProperty
    public void setWhiteList(Collection<InetSocketAddress> whiteList) {
        this.whiteList = whiteList;
    }

    @Override
    public LoadBalancingPolicy build() {
        return new WhiteListPolicy(this.subPolicy.build(), this.whiteList);
    }
}

