/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.postgres.form.LanguageForm;
import systems.dennis.shared.postgres.model.LanguageModel;
import systems.dennis.shared.postgres.service.LanguageService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/flaw/language"})
@WebFormsSupport(value=LanguageService.class)
@CrossOrigin
@Secured(roles={"ROLE_ADMIN"})
public class LanguageController
extends ApplicationContext
implements AddItemController<LanguageModel, LanguageForm>,
EditItemController<LanguageModel, LanguageForm>,
ListItemController<LanguageModel, LanguageForm>,
DeleteItemController<LanguageModel> {
    @Override
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResponseEntity<Page<Map<String, Object>>> get(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        return ListItemController.super.get(limit, page);
    }

    @Override
    @PostMapping(value={"/root/fetch/data", "/root/fetch/data/"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    public Page<Map<String, Object>> fetchData(@RequestBody MagicRequest request) {
        return ListItemController.super.fetchData(request);
    }

    public LanguageController(WebContext context) {
        super(context);
    }

    static {
        SearchEntityApi.registerSearch((String)"language", (SearcherInfo)new SearcherInfo("name", LanguageService.class));
    }
}

