/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.controller;

import java.io.Serializable;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.items.AbstractParentalController;
import systems.dennis.shared.form.CountResponse;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.postgres.model.BaseEntity;

@Secured
public interface ParentalController<T extends BaseEntity, E extends DefaultForm>
extends AbstractParentalController<T, E, Long> {
    @GetMapping(value={"/tree/count/parent/{id}"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<CountResponse> countByParent(@PathVariable(value="id") Long id) {
        return super.countByParent((Serializable)id);
    }

    @GetMapping(value={"/tree/parent/{id}"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<Map<String, Object>>> findByParent(@PathVariable(value="id") Long id, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        return super.findByParent((Serializable)id, limit, page);
    }

    @GetMapping(value={"/tree/root"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<Map<String, Object>>> findRootElements(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        return super.findRootElements(limit, page);
    }
}

