/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.model;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.postgres.model.LongIdValidatorImpl;

@MappedSuperclass
public abstract class BaseEntity
extends IDPresenter<Long> {
    private static final LongIdValidatorImpl validator = new LongIdValidatorImpl();
    @Id
    @GeneratedValue(generator="entity-aware-generator", strategy=GenerationType.SEQUENCE)
    @GenericGenerator(name="entity-aware-generator", parameters={@Parameter(name="increment_size", value="1"), @Parameter(name="initial_value", value="100")}, strategy="systems.dennis.shared.postgres.model.ByEntityNameSequenceGenerator")
    private Long id;

    public boolean isIdSet() {
        return validator.isIdSet(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "BaseEntity(id=" + this.getId() + ")";
    }
}

