/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.model;

import java.util.Properties;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.springframework.data.mapping.MappingException;
import systems.dennis.shared.annotations.SequenceParams;

public class ByEntityNameSequenceGenerator
extends SequenceStyleGenerator {
    public static final String NAME = ByEntityNameSequenceGenerator.class.getName();

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        String entityName = params.getProperty("entity_name");
        if (entityName == null) {
            throw new IllegalStateException("Entity name must not be null");
        }
        Class entityClass = ((ClassLoaderService)serviceRegistry.requireService(ClassLoaderService.class)).classForName(entityName);
        SequenceParams ann = entityClass.getAnnotation(SequenceParams.class);
        if (ann != null) {
            params.setProperty("increment_size", String.valueOf(ann.increment()));
            params.setProperty("initial_value", String.valueOf(ann.init()));
        }
        params.setProperty("sequence_name", entityClass.getSimpleName() + "_seq");
        super.configure(type, params, serviceRegistry);
    }
}

