/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository;

import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.shared.exceptions.StandardException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.postgres.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class SpecificationFilter<T extends IDPresenter<?>>
implements AbstractDataFilter<T> {
    boolean empty = true;
    private Specification<T> root;
    private boolean complex;
    private String on;
    private Class<?> type;
    boolean calculated = false;
    private boolean insensitive;
    private boolean closed;
    private String operationType;
    private Object value;
    private String field;
    private List<SpecificationFilter<T>> or = new ArrayList<SpecificationFilter<T>>();
    private List<SpecificationFilter<T>> and = new ArrayList<SpecificationFilter<T>>();

    public SpecificationFilter<T> operator(String field, Object value, String type) {
        if (this.isClosed()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "only add/or functions are now available. Please check that 'operation' is performed after additional parameter' ");
        }
        if (field != null && type != null) {
            this.setEmpty(false);
        }
        this.field = field;
        this.value = value;
        this.operationType = type;
        this.root = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            AbstractClassProcessor qq = AbstractClassProcessor.processor(this, root);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!qq.isNotNullCase()) {
                qq.addToNullOrNotNullPredicate(criteriaBuilder, root, predicates);
            } else {
                qq.processDefault(criteriaBuilder, predicates);
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        this.closed = true;
        return this;
    }

    private Specification<T> getRoot() {
        return this.root;
    }

    public <E extends AbstractDataFilter<?>> E and(E filter) {
        if (this.isCalculated()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "due to limitations of Query you cannot use Query after you had already called method 'getCriteriaRoot()'");
        }
        this.and.add((SpecificationFilter)filter);
        this.empty = false;
        return (E)this;
    }

    public <E extends AbstractDataFilter<?>> E or(E filter) {
        if (this.isCalculated()) {
            throw new StandardException((Serializable)((Object)"query_was_already_closed"), "due to limitations of Query you cannot use Query after you had already called method 'getCriteriaRoot()'");
        }
        this.or.add((SpecificationFilter)filter);
        this.empty = false;
        return (E)this;
    }

    public <E extends AbstractDataFilter<T>> E comparasionType(Class<?> type) {
        this.type = type;
        return (E)this;
    }

    public SpecificationFilter<T> setInsensitive(boolean insensitive) {
        this.insensitive = insensitive;
        return this;
    }

    public SpecificationFilter<T> setComplex(boolean complex) {
        this.complex = complex;
        return this;
    }

    public SpecificationFilter<T> setJoinOn(String on) {
        this.on = on;
        this.setComplex(true);
        return this;
    }

    public Serializable getIdValue(Object id) {
        return (Long)id;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getOperator() {
        return this.operationType;
    }

    boolean isEmpty(AbstractDataFilter<?> filter) {
        return filter == null || filter.isEmpty();
    }

    public Class<?> getFieldClass() {
        try {
            return this.type == null ? this.getValue().getClass() : this.type;
        }
        catch (Exception e) {
            return String.class;
        }
    }

    public <E> E getQueryRoot() {
        if (this.calculated) {
            return (E)this.root;
        }
        if (!this.or.isEmpty()) {
            this.or.forEach(x -> {
                x.getQueryRoot();
                this.root = this.root.or(x.getRoot());
            });
        }
        if (!this.and.isEmpty()) {
            this.and.forEach(x -> {
                x.getQueryRoot();
                this.root = this.root.and(x.getRoot());
            });
        }
        this.calculated = true;
        return (E)this.root;
    }

    public boolean getInsensitive() {
        return this.insensitive;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public String getOn() {
        return this.on;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public Object getValue() {
        return this.value;
    }

    public String getField() {
        return this.field;
    }

    public List<SpecificationFilter<T>> getOr() {
        return this.or;
    }

    public List<SpecificationFilter<T>> getAnd() {
        return this.and;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public void setRoot(Specification<T> root) {
        this.root = root;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setOr(List<SpecificationFilter<T>> or) {
        this.or = or;
    }

    public void setAnd(List<SpecificationFilter<T>> and) {
        this.and = and;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecificationFilter)) {
            return false;
        }
        SpecificationFilter other = (SpecificationFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.isComplex() != other.isComplex()) {
            return false;
        }
        if (this.isCalculated() != other.isCalculated()) {
            return false;
        }
        if (this.getInsensitive() != other.getInsensitive()) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        Specification<T> this$root = this.getRoot();
        Specification<T> other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        String this$on = this.getOn();
        String other$on = other.getOn();
        if (this$on == null ? other$on != null : !this$on.equals(other$on)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$operationType = this.getOperationType();
        String other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        List<SpecificationFilter<T>> this$or = this.getOr();
        List<SpecificationFilter<T>> other$or = other.getOr();
        if (this$or == null ? other$or != null : !((Object)this$or).equals(other$or)) {
            return false;
        }
        List<SpecificationFilter<T>> this$and = this.getAnd();
        List<SpecificationFilter<T>> other$and = other.getAnd();
        return !(this$and == null ? other$and != null : !((Object)this$and).equals(other$and));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecificationFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEmpty() ? 79 : 97);
        result = result * 59 + (this.isComplex() ? 79 : 97);
        result = result * 59 + (this.isCalculated() ? 79 : 97);
        result = result * 59 + (this.getInsensitive() ? 79 : 97);
        result = result * 59 + (this.isClosed() ? 79 : 97);
        Specification<T> $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        String $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : $on.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        List<SpecificationFilter<T>> $or = this.getOr();
        result = result * 59 + ($or == null ? 43 : ((Object)$or).hashCode());
        List<SpecificationFilter<T>> $and = this.getAnd();
        result = result * 59 + ($and == null ? 43 : ((Object)$and).hashCode());
        return result;
    }

    public String toString() {
        return "SpecificationFilter(empty=" + this.isEmpty() + ", root=" + String.valueOf(this.getRoot()) + ", complex=" + this.isComplex() + ", on=" + this.getOn() + ", type=" + String.valueOf(this.getType()) + ", calculated=" + this.isCalculated() + ", insensitive=" + this.getInsensitive() + ", closed=" + this.isClosed() + ", operationType=" + this.getOperationType() + ", value=" + String.valueOf(this.getValue()) + ", field=" + this.getField() + ", or=" + String.valueOf(this.getOr()) + ", and=" + String.valueOf(this.getAnd()) + ")";
    }
}

