/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository.query_processors;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import systems.dennis.shared.postgres.repository.SpecificationFilter;
import systems.dennis.shared.postgres.repository.query_processors.CollectionPredicateProcessor;
import systems.dennis.shared.postgres.repository.query_processors.DatePredicateProcessor;
import systems.dennis.shared.postgres.repository.query_processors.NumberPredicateProcessor;
import systems.dennis.shared.postgres.repository.query_processors.SimplePredicateProcessor;
import systems.dennis.shared.postgres.repository.query_processors.StringPredicateProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public abstract class AbstractClassProcessor {
    private AbstractDataFilter filter;
    private Root root;
    private Class<?> type = String.class;
    private Object parameter = null;

    public AbstractClassProcessor(AbstractDataFilter AbstractDataFilter2, Root root) {
        this.filter = AbstractDataFilter2;
        this.root = root;
        if (AbstractDataFilter2.getFieldClass() == null && AbstractDataFilter2.getValue() != null) {
            this.type = AbstractDataFilter2.getValue().getClass();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNotNullCase() {
        if ("notNull".equalsIgnoreCase(this.filter.getOperator())) return false;
        if ("null".equalsIgnoreCase(this.filter.getOperator())) return false;
        return true;
    }

    public void addToNullOrNotNullPredicate(CriteriaBuilder criteriaBuilder, Root root, List<Predicate> predicates) {
        if (Objects.equals(this.getFilter().getOperator(), "null")) {
            predicates.add(criteriaBuilder.isNull(this.getPath(root)));
        } else {
            predicates.add(criteriaBuilder.isNotNull(this.getPath(root)));
        }
    }

    public <T> Expression<T> getPath(Root root) {
        if (!this.getFilter().isComplex()) {
            return root.get(this.getFilter().getField());
        }
        String[] paths = this.getFilter().getOn().split("\\.");
        Join join = null;
        for (String j : paths) {
            join = join == null ? root.join(j) : join.join(j);
        }
        return join.get(this.getFilter().getField());
    }

    public void processDefault(CriteriaBuilder criteriaBuilder, List<Predicate> predicates) {
        Object value = this.getValue(this.filter.getValue());
        if (value == null) {
            throw new ArithmeticException("Item is wrong type");
        }
        if ("lt".equalsIgnoreCase(this.filter.getOperator())) {
            predicates.add(criteriaBuilder.lessThan(this.getPath(this.root), (Comparable)((Date)value)));
        }
        if ("gt".equalsIgnoreCase(this.filter.getOperator())) {
            predicates.add(criteriaBuilder.greaterThan(this.getPath(this.root), (Comparable)((Date)value)));
        }
        if ("le".equalsIgnoreCase(this.filter.getOperator())) {
            predicates.add(criteriaBuilder.lessThanOrEqualTo(this.getPath(this.root), (Comparable)((Date)value)));
        }
        if ("ge".equalsIgnoreCase(this.filter.getOperator())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo(this.getPath(this.root), (Comparable)((Date)value)));
        }
        if ("notNull".equalsIgnoreCase(this.filter.getOperator())) {
            predicates.add(criteriaBuilder.isNotNull(this.getPath(this.root)));
        }
        if ("null".equalsIgnoreCase(this.filter.getOperator())) {
            predicates.add(criteriaBuilder.isNull(this.getPath(this.root)));
        }
        if ("equals".equalsIgnoreCase(this.filter.getOperator()) && !String.class.isAssignableFrom(this.filter.getValue().getClass())) {
            predicates.add(criteriaBuilder.equal(this.getPath(this.root), value));
        }
        if ("notEquals".equalsIgnoreCase(this.filter.getOperator())) {
            this.addIsNullOrNotEqualPredicate(criteriaBuilder, predicates, value);
        }
        if ("in".equalsIgnoreCase(this.filter.getOperator())) {
            CriteriaBuilder.In inClause = criteriaBuilder.in(this.getPath(this.root));
            Collection cValue = (Collection)value;
            cValue.forEach(x -> inClause.value(x));
            predicates.add((Predicate)inClause);
        }
    }

    protected void addIsNullOrNotEqualPredicate(CriteriaBuilder criteriaBuilder, List<Predicate> predicates, Object value) {
        predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.isNull(this.getPath(this.root)), (Expression)criteriaBuilder.notEqual(this.getPath(this.root), value)));
    }

    public abstract Object getValue(Object var1);

    public static AbstractClassProcessor processor(SpecificationFilter fitler, Root root) {
        if (fitler.getFieldClass() != null && Collection.class.isAssignableFrom(fitler.getFieldClass())) {
            return new CollectionPredicateProcessor(fitler, root);
        }
        if (Date.class.equals(fitler.getFieldClass()) && !Date.class.isAssignableFrom(fitler.getValue().getClass())) {
            return new DatePredicateProcessor(fitler, root);
        }
        if (fitler.getFieldClass() != null && (Number.class.isAssignableFrom(fitler.getFieldClass()) || AbstractClassProcessor.isPrimitiveNumber(fitler.getFieldClass()))) {
            return new NumberPredicateProcessor(fitler, root);
        }
        if (fitler.getFieldClass() != null && String.class.isAssignableFrom(fitler.getFieldClass())) {
            return new StringPredicateProcessor(fitler, root);
        }
        return new SimplePredicateProcessor(fitler, root);
    }

    private static boolean isPrimitiveNumber(Class c) {
        return Integer.TYPE == c || Long.TYPE == c || Short.TYPE == c || Double.TYPE == c || Float.TYPE == c;
    }

    public AbstractDataFilter getFilter() {
        return this.filter;
    }

    public Root getRoot() {
        return this.root;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setFilter(AbstractDataFilter filter) {
        this.filter = filter;
    }

    public void setRoot(Root root) {
        this.root = root;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractClassProcessor)) {
            return false;
        }
        AbstractClassProcessor other = (AbstractClassProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbstractDataFilter this$filter = this.getFilter();
        AbstractDataFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Root this$root = this.getRoot();
        Root other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$parameter = this.getParameter();
        Object other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractClassProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbstractDataFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Root $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractClassProcessor(filter=" + String.valueOf(this.getFilter()) + ", root=" + String.valueOf(this.getRoot()) + ", type=" + String.valueOf(this.getType()) + ", parameter=" + String.valueOf(this.getParameter()) + ")";
    }
}

