/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.postgres.repository.query_processors;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import systems.dennis.shared.postgres.repository.SpecificationFilter;
import systems.dennis.shared.postgres.repository.query_processors.AbstractClassProcessor;
import systems.dennis.shared.repository.AbstractDataFilter;

public class CollectionPredicateProcessor
extends AbstractClassProcessor {
    public CollectionPredicateProcessor(SpecificationFilter queryCase, Root root) {
        super(queryCase, root);
    }

    @Override
    public void processDefault(CriteriaBuilder criteriaBuilder, List<Predicate> predicates) {
        Collection cValue;
        CriteriaBuilder.In inClause;
        Expression collectionExpression = this.getPath(this.getRoot());
        AbstractDataFilter queryCase = this.getFilter();
        if ("contains".equalsIgnoreCase(queryCase.getOperator())) {
            predicates.add(criteriaBuilder.isMember((Object)String.valueOf(queryCase.getValue()), collectionExpression));
        }
        if ("_nc_".equalsIgnoreCase(queryCase.getOperator())) {
            predicates.add(criteriaBuilder.isNotMember((Object)String.valueOf(queryCase.getValue()), collectionExpression));
        }
        if ("_ne_".equalsIgnoreCase(queryCase.getOperator())) {
            predicates.add(criteriaBuilder.isNotEmpty(collectionExpression));
        }
        if ("_em_".equalsIgnoreCase(queryCase.getOperator())) {
            predicates.add(criteriaBuilder.isEmpty(collectionExpression));
        }
        if ("in".equalsIgnoreCase(queryCase.getOperator())) {
            inClause = criteriaBuilder.in(this.getPath(this.getRoot()));
            cValue = (Collection)queryCase.getValue();
            cValue.forEach(x -> inClause.value(x));
            predicates.add((Predicate)inClause);
        }
        if ("not_in".equalsIgnoreCase(queryCase.getOperator())) {
            inClause = criteriaBuilder.in(this.getPath(this.getRoot()));
            cValue = (Collection)queryCase.getValue();
            cValue.forEach(x -> inClause.value(x));
            predicates.add(criteriaBuilder.not((Expression)inClause));
        }
        if ("notEquals".equalsIgnoreCase(queryCase.getOperator())) {
            Collection cValue2 = (Collection)queryCase.getValue();
            ArrayList<Predicate> notEqualPredicates = new ArrayList<Predicate>();
            for (Object value : cValue2) {
                Predicate notEqualPredicate = criteriaBuilder.notEqual(collectionExpression, value);
                notEqualPredicates.add(notEqualPredicate);
            }
            Predicate combinedNotEqualPredicates = criteriaBuilder.and(notEqualPredicates.toArray(new Predicate[notEqualPredicates.size()]));
            predicates.add(combinedNotEqualPredicates);
        }
    }

    @Override
    public Object getValue(Object value) {
        return value;
    }
}

