/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.scopes.form.DictionaryForm;
import systems.dennis.shared.scopes.model.DictionaryModel;
import systems.dennis.shared.scopes.service.DictionaryService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/dictionary"})
@WebFormsSupport(value=DictionaryService.class)
@CrossOrigin
public class DictionaryController
extends ApplicationContext
implements AddItemController<DictionaryModel, DictionaryForm>,
EditItemController<DictionaryModel, DictionaryForm>,
ListItemController<DictionaryModel, DictionaryForm>,
DeleteItemController<DictionaryModel> {
    public DictionaryController(WebContext context) {
        super(context);
    }

    @PostMapping(value={"/add"}, consumes={"application/json", "application/json;charset=UTF-8"}, produces={"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<DictionaryForm> add(DictionaryForm form) throws ItemForAddContainsIdException {
        return super.add((DefaultForm)form);
    }

    @PutMapping(value={"/edit"}, consumes={"application/json", "application/json;charset=UTF-8"}, produces={"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<DictionaryForm> edit(DictionaryForm form) throws ItemForAddContainsIdException {
        return super.edit((DefaultForm)form);
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @WithRole(value="ROLE_ADMIN")
    public void delete(Long id) throws ItemForAddContainsIdException {
        super.delete(id);
    }

    static {
        SearchEntityApi.registerSearch((String)"dictionary", (SearcherInfo)new SearcherInfo("value", DictionaryService.class));
    }
}

