/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.scopes.service.DictionaryService;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class DictionaryModel
extends BaseEntity {
    public static final int TYPE_INT = 0;
    public static final int TYPE_STRING = 1;
    public static final String DICTIONARY_FIELD = "value";
    @ObjectByIdPresentation
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=DictionaryService.class)
    private DictionaryModel parent;
    private String type;
    private Integer dataType = 1;
    private String value;

    public String asValue() {
        if (this.parent == null) {
            return this.value;
        }
        return this.value + " (" + this.parent.value + ")";
    }

    public DictionaryModel getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    public String getValue() {
        return this.value;
    }

    public void setParent(DictionaryModel parent) {
        this.parent = parent;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictionaryModel)) {
            return false;
        }
        DictionaryModel other = (DictionaryModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$dataType = this.getDataType();
        Integer other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        DictionaryModel this$parent = this.getParent();
        DictionaryModel other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)((Object)this$parent)).equals((Object)other$parent)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DictionaryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        DictionaryModel $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)((Object)$parent)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "DictionaryModel(parent=" + String.valueOf((Object)this.getParent()) + ", type=" + this.getType() + ", dataType=" + this.getDataType() + ", value=" + this.getValue() + ")";
    }
}

