/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.service;

import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.scopes.exception.DictionaryException;
import systems.dennis.shared.scopes.form.DictionaryForm;
import systems.dennis.shared.scopes.model.DictionaryModel;
import systems.dennis.shared.scopes.repository.DictionaryRepo;

@Service
@DataRetrieverDescription(model=DictionaryModel.class, form=DictionaryForm.class, repo=DictionaryRepo.class)
public class DictionaryService
extends PaginationService<DictionaryModel> {
    public DictionaryService(WebContext holder) {
        super(holder);
    }

    public Page<DictionaryModel> search(String field, String subtype, String value, int page, Integer size, Serializable[] additionalIds) {
        try {
            AbstractDataFilter spec = this.getSearchRequestSpecification("value", value, this.updateIds(additionalIds));
            spec = spec.and(this.getFilterImpl().eq("type", (Object)subtype));
            return this.getRepository().filteredData(spec, (Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"value"})));
        }
        catch (Exception e) {
            throw new DictionaryException("global.search.dictionary.failed", HttpStatus.BAD_REQUEST);
        }
    }

    public AbstractDataFilter<DictionaryModel> getSearchRequestSpecification(String field, String value, Long[] additionalIds) {
        AbstractDataFilter filter = this.getFilterImpl().setInsensitive(true).contains(field, value).and(this.getAdditionalSpecification());
        if (additionalIds != null) {
            filter.and(this.getFilterImpl().eq("group", (Object)additionalIds[0]));
        }
        return filter;
    }

    public boolean isPublicSearchEnabled() {
        return true;
    }

    public DictionaryRepo getRepository() {
        return (DictionaryRepo)super.getRepository();
    }

    public List<String> getDictionaryTypes() {
        return this.getRepository().getDictionaryTypes();
    }
}

