/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.TranslationException;

@Service
public class LocaleBean {
    private static final Logger log = LoggerFactory.getLogger(LocaleBean.class);
    public static final String GLOBAL_USE_CACHE_TRANSLATION = "global.use_cache_translation";
    public static final String GLOBAL_MESSAGE_PATH = "global.messages.path";
    private Map<String, List<KeyValue>> cache = new HashMap<String, List<KeyValue>>();

    public String transform(String localeName, WebContext context) {
        File directory = new File(this.getMessagesPath(context));
        if (directory == null || !directory.isDirectory()) {
            throw new TranslationException(localeName);
        }
        List<File> filesFromDirectory = Arrays.asList(directory.listFiles());
        for (File file : filesFromDirectory) {
            String fileNameWithoutProp;
            List<String> fileParts;
            if (!file.getName().contains(".properties") || !(fileParts = List.of((fileNameWithoutProp = List.of(file.getName().split("\\.")).get(0)).split("_"))).get(0).equals("messages") || !fileParts.get(1).equals(localeName) || fileParts.size() != 3) continue;
            return localeName + "_" + fileParts.get(2);
        }
        throw new TranslationException(localeName);
    }

    public List<KeyValue> getMessageTranslations(String lang, WebContext context) {
        block6: {
            if (lang == null || lang.isBlank()) {
                throw new TranslationException(lang);
            }
            if (this.isUseCache(context) && this.cache.containsKey(lang)) {
                return this.cache.get(lang);
            }
            Object i18n = this.getMessagesPath(context);
            if (i18n != null && Files.exists(Path.of((String)i18n, new String[0]), new LinkOption[0])) {
                String langToLoad = this.transform(lang, context);
                i18n = (String)i18n + File.separator + "messages_" + langToLoad + ".properties";
                try {
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader((InputStream)new FileInputStream((String)i18n), StandardCharsets.UTF_8));
                    ArrayList<KeyValue> res = new ArrayList<KeyValue>();
                    Enumeration<Object> items = properties.keys();
                    while (items.hasMoreElements()) {
                        String key = items.nextElement().toString();
                        res.add(new KeyValue(key, properties.getProperty(key)));
                    }
                    this.cache.put(lang, res);
                    return res;
                }
                catch (Exception e) {
                    if (!this.isUseCache(context)) break block6;
                    this.cache.put(lang, Collections.singletonList(new KeyValue("error", "lang_not_supported")));
                }
            }
        }
        return null;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public boolean isUseCache(WebContext context) {
        return context.getEnv(GLOBAL_USE_CACHE_TRANSLATION, true);
    }

    public String getMessagesPath(WebContext context) {
        return context.getEnv(GLOBAL_MESSAGE_PATH, "./i18n");
    }
}

