/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.beans;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMapping;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.entity.CreatedBy;
import systems.dennis.shared.beans.OnAppStart;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.ApplicationStartFailedException;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Configuration
public class OnApplicationStart {
    private static final Logger log = LoggerFactory.getLogger(OnApplicationStart.class);

    @Autowired(required=false)
    @Bean
    public CommandLineRunner init(WebContext context, ApplicationContext applicationContext, OnAppStart onAppStart) {
        return args -> {
            try {
                Map controllers = applicationContext.getBeansWithAnnotation(WebFormsSupport.class);
                for (Object controller : controllers.values()) {
                    Class targetClass = AopUtils.getTargetClass(controller);
                    WebFormsSupport support = targetClass.getAnnotation(WebFormsSupport.class);
                    if (!support.allowEntitySearch()) continue;
                    String name = OnApplicationStart.getSearchName(targetClass);
                    String fieldName = OnApplicationStart.getFieldName(targetClass);
                    if (fieldName != null && name != null) {
                        SearchEntityApi.registerSearch(name, new SearcherInfo(fieldName, support.value()));
                    }
                    this.checkForCreatedAnnotations(support, targetClass, context);
                }
            }
            catch (Exception e) {
                log.info("error during automatic SearchEntity filling: ", (Throwable)e);
            }
            if (onAppStart != null) {
                onAppStart.onAppRun(context);
            }
        };
    }

    private void checkForCreatedAnnotations(WebFormsSupport support, Class<?> targetClass, WebContext context) {
        Class<? extends AbstractEntity> model = support.value().getAnnotation(DataRetrieverDescription.class).model();
        List<Field> createdFields = BeanCopier.findAnnotatedFields(model, CreatedBy.class, 0);
        if (createdFields.size() > 1) {
            throw new ApplicationStartFailedException(model, "global.few.created_annotations");
        }
        if (createdFields.size() == 1) {
            systems.dennis.shared.utils.ApplicationContext.CREATED_FIELDS_MAP.put(model, createdFields.get(0));
        }
    }

    public static String getFieldName(Class<?> controller) {
        WebFormsSupport support = controller.getAnnotation(WebFormsSupport.class);
        if (!Objects.equals("default", support.fieldName())) {
            return support.fieldName();
        }
        Class<? extends AbstractEntity> model = support.value().getAnnotation(DataRetrieverDescription.class).model();
        for (Field field : model.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.getType() != String.class) continue;
            return field.getName();
        }
        return null;
    }

    public static String getSearchName(Class<?> controller) {
        WebFormsSupport support = controller.getAnnotation(WebFormsSupport.class);
        String name = support.searchName();
        if (Objects.equals(name, "default")) {
            name = OnApplicationStart.retrieveNameFromPath(controller);
        }
        return name;
    }

    public static String retrieveNameFromPath(Class<?> controller) {
        String[] mapping = controller.getAnnotation(RequestMapping.class).value();
        if (mapping.length == 0) {
            return null;
        }
        String mappingControllerPath = mapping[0];
        if (mappingControllerPath.endsWith("/")) {
            mappingControllerPath = mappingControllerPath.substring(0, mappingControllerPath.length() - 1);
        }
        String[] name = mappingControllerPath.split("/");
        return name[name.length - 1];
    }
}

