/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.config;

import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.stereotype.Service;

@Service
public class MessageResourceSource
extends AbstractResourceBasedMessageSource {
    private static final Logger log = LoggerFactory.getLogger(MessageResourceSource.class);
    private static final Map<String, Properties> values = new HashMap<String, Properties>();
    @Value(value="${global.messages.path: ./i18n}")
    private String messagesPath;

    public void init(String path) {
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory() || dir.listFiles() == null) {
            log.error("Not a valid massage source dir " + dir.getAbsolutePath());
            return;
        }
        for (File file : dir.listFiles()) {
            String ext = file.getName().replace(".properties", "");
            String locale = ext.substring(ext.length() - 2).toLowerCase();
            Properties properties = new Properties();
            properties.load(new FileReader(file.getAbsoluteFile(), StandardCharsets.UTF_8));
            values.put(locale, properties);
        }
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        Object res;
        if (values.size() == 0) {
            this.init(this.messagesPath);
        }
        try {
            String country = locale.getCountry().toLowerCase();
            if (country == null || country.length() == 0) {
                country = locale.getLanguage().substring(3, 5);
            }
            res = values.get(country).get(code);
        }
        catch (Exception e) {
            res = null;
        }
        if (res == null) {
            System.out.println(code);
            return new MessageFormat("[" + code + "]");
        }
        return new MessageFormat(res.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map<String, Properties> map = values;
        synchronized (map) {
            values.clear();
            this.init(this.messagesPath);
        }
    }
}

