/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.config;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.beans.AbstractDataFilterProvider;
import systems.dennis.shared.beans.AppSettingsResolver;
import systems.dennis.shared.beans.IdToAuthorizationIdBean;
import systems.dennis.shared.beans.LocaleBean;
import systems.dennis.shared.config.MessageResourceSource;
import systems.dennis.shared.config.OnNull;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.exceptions.SettingKeyNotFoundException;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Service
public class WebContext {
    private static final Logger log = LoggerFactory.getLogger(WebContext.class);
    public static final Map<String, Object> data = new HashMap<String, Object>();
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MessageResourceSource messages;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Environment environment;
    @Autowired
    private LocaleBean localeBean;
    @Autowired
    private final IdToAuthorizationIdBean id2id;
    private static AppSettingsResolver resolver;
    private static AppSettingsResolver EMPTY_RESOLVER;

    @Deprecated
    public Object toCache(String what, Object cache) {
        return data.put(what, cache);
    }

    @Deprecated
    public <T> T fromCache(String what, OnNull<T> def) {
        Object res = data.get(what);
        if (res == null) {
            return def.def();
        }
        return (T)res;
    }

    static AppSettingsResolver getResolver(WebContext context) {
        if (resolver == null || Objects.equals(resolver, EMPTY_RESOLVER)) {
            return null;
        }
        resolver = context.getBean(AppSettingsResolver.class, EMPTY_RESOLVER);
        return resolver;
    }

    public <T> T getEnv(String key) {
        AppSettingsResolver resolver = this.getBean(AppSettingsResolver.class, null);
        if (resolver == null) {
            return (T)this.environment.getProperty(key);
        }
        return resolver.getEnv(key);
    }

    public <T> T getEnv(String key, T def) {
        try {
            T env = this.getEnv(key);
            if (Objects.isNull(env)) {
                return def;
            }
            return env;
        }
        catch (SettingKeyNotFoundException e) {
            return def;
        }
    }

    public TokenData getToken() {
        return this.getBean(ISecurityUtils.class).getToken();
    }

    private String getMessageTranslation(String header, String lang) {
        this.messages.resolveCode(header, new Locale(this.localeBean.transform(lang, this)));
        String message = this.messages.getMessage(header.toLowerCase(), new Object[0], "?_" + header + "_?", new Locale(this.localeBean.transform(lang, this)));
        if (message == null || message.startsWith("?_") && message.endsWith("_?")) {
            log.warn(header + " not found !");
        }
        return message;
    }

    private String getMessageTranslation(String header, String lang, Object ... params) {
        return this.getMessageTranslation(header, new Locale(this.localeBean.transform(lang, this)), params);
    }

    private String getMessageTranslation(String header, Locale locale, Object ... params) {
        String message = this.messages.getMessage(header.toLowerCase(), params, "?_" + header + "_?", locale);
        if (message == null || message.startsWith("?_") && message.endsWith("_?")) {
            log.warn(header + " not found !");
        }
        return message;
    }

    public <T extends Serializable> T currentUser() {
        return this.getBean(ISecurityUtils.class).getUserDataId();
    }

    private ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public <T> T getBean(Class<T> value) {
        return (T)this.getApplicationContext().getBean(value);
    }

    public <T> T getBean(Class<T> value, T def) {
        try {
            return (T)this.getApplicationContext().getBean(value);
        }
        catch (BeansException e) {
            return def;
        }
    }

    public WebContext(HttpServletRequest request, MessageResourceSource messages, ApplicationContext applicationContext, Environment environment, LocaleBean localeBean, IdToAuthorizationIdBean id2id) {
        this.request = request;
        this.messages = messages;
        this.applicationContext = applicationContext;
        this.environment = environment;
        this.localeBean = localeBean;
        this.id2id = id2id;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public MessageResourceSource getMessages() {
        return this.messages;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public LocaleBean getLocaleBean() {
        return this.localeBean;
    }

    public IdToAuthorizationIdBean getId2id() {
        return this.id2id;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setMessages(MessageResourceSource messages) {
        this.messages = messages;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setLocaleBean(LocaleBean localeBean) {
        this.localeBean = localeBean;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebContext)) {
            return false;
        }
        WebContext other = (WebContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpServletRequest this$request = this.getRequest();
        HttpServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        MessageResourceSource this$messages = this.getMessages();
        MessageResourceSource other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)((Object)this$messages)).equals((Object)other$messages)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        LocaleBean this$localeBean = this.getLocaleBean();
        LocaleBean other$localeBean = other.getLocaleBean();
        if (this$localeBean == null ? other$localeBean != null : !this$localeBean.equals(other$localeBean)) {
            return false;
        }
        IdToAuthorizationIdBean this$id2id = this.getId2id();
        IdToAuthorizationIdBean other$id2id = other.getId2id();
        return !(this$id2id == null ? other$id2id != null : !this$id2id.equals(other$id2id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        MessageResourceSource $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)((Object)$messages)).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        LocaleBean $localeBean = this.getLocaleBean();
        result = result * 59 + ($localeBean == null ? 43 : $localeBean.hashCode());
        IdToAuthorizationIdBean $id2id = this.getId2id();
        result = result * 59 + ($id2id == null ? 43 : $id2id.hashCode());
        return result;
    }

    public String toString() {
        return "WebContext(request=" + String.valueOf(this.getRequest()) + ", messages=" + String.valueOf((Object)this.getMessages()) + ", applicationContext=" + String.valueOf(this.getApplicationContext()) + ", environment=" + String.valueOf(this.getEnvironment()) + ", localeBean=" + String.valueOf(this.getLocaleBean()) + ", id2id=" + String.valueOf(this.getId2id()) + ")";
    }

    static {
        EMPTY_RESOLVER = new AppSettingsResolver(){

            @Override
            public boolean hasSetting(String setting) {
                return false;
            }

            public String getEnv(String key) {
                return null;
            }

            public String getEnv(String key, Object def) {
                return null;
            }
        };
    }

    public static class LocalWebContext {
        private final WebContext webContext;
        private String scope;

        public HttpServletRequest getRequest() {
            return this.webContext.getRequest();
        }

        public String httpParam(String param) {
            return this.webContext.getRequest().getParameter(param);
        }

        public WebContext getWebContext() {
            return this.webContext;
        }

        public String getMessageTranslation(String header, String lang) {
            return this.webContext.getMessageTranslation(this.scope + "." + header.toLowerCase(), lang);
        }

        public AbstractDataFilter<?> getDataFilterProvider() {
            return this.getBean(AbstractDataFilterProvider.class).get();
        }

        public String getMessageTranslation(String header, String lang, Class parentScope) {
            return this.webContext.getMessageTranslation(parentScope.getName() + "." + header.toLowerCase(), lang);
        }

        public String getMessageTranslation(String header, String lang, Object ... params) {
            return this.webContext.getMessageTranslation(this.scope + "." + header.toLowerCase(), lang, params);
        }

        private LocalWebContext(String scope, WebContext context) {
            this.scope = scope;
            this.webContext = context;
        }

        public static LocalWebContext of(String scope, WebContext context) {
            return new LocalWebContext(scope, context);
        }

        public <T> T getEnv(String key) {
            return this.webContext.getEnv(key);
        }

        public <T> T getEnv(String key, T def) {
            return this.webContext.getEnv(key, def);
        }

        public <T extends Serializable> T getCurrentUser() {
            return (T)this.getWebContext().id2id.idToAuthorizationId((Serializable)this.getBean(ISecurityUtils.class).getUserDataId());
        }

        public <T> T transform(Object item, Class<? extends T> testPlanViewClass) {
            return this.getBean(BeanCopier.class).copy(item, testPlanViewClass);
        }

        public String getScoped(String header) {
            return this.scope + "." + header;
        }

        public <T> T getBean(Class<T> bean) {
            return (T)this.webContext.getApplicationContext().getBean(bean);
        }
    }
}

