/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.ApiErrorDescription;
import systems.dennis.shared.controller.ExternalControllerAdvice;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.exceptions.EditableObjectNotFoundException;
import systems.dennis.shared.exceptions.HistoryObjectNotFoundException;
import systems.dennis.shared.exceptions.IllegalIdException;
import systems.dennis.shared.exceptions.ItemAlreadyExistsException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemWasDeletedException;
import systems.dennis.shared.exceptions.TranslationException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.exceptions.ValidationFailedException;
import systems.dennis.shared.utils.Mapper;

@ControllerAdvice
public class GlobalExceptionController {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionController.class);
    public static String REDIRECT_PARAM = "redirect";
    private ExternalControllerAdvice external = null;

    public GlobalExceptionController(WebContext context) {
        try {
            this.external = context.getBean(ExternalControllerAdvice.class);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object exception(Exception e, HttpServletResponse response, WebRequest request) {
        Object res;
        e.printStackTrace();
        Object object = res = this.external == null ? null : this.external.onException(e.getClass(), e, response, request, this);
        if (res == null) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setContentType("application/json");
            return Mapper.mapper.writeValueAsString((Object)ApiErrorDescription.of(e, ((ServletWebRequest)request).getRequest().getRequestURI()));
        }
        return res;
    }

    @ExceptionHandler(value={ValidationFailedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Object validationFailed(ValidationFailedException e, HttpServletResponse response, WebRequest request) {
        return new ObjectMapper().writeValueAsString(e.getErrorMessages());
    }

    @ExceptionHandler(value={UnmodifiedItemSaveAttemptException.class})
    @ResponseStatus(value=HttpStatus.NOT_MODIFIED)
    @ResponseBody
    public Object unmodifiedItemSaveAttempt(UnmodifiedItemSaveAttemptException ex, HttpServletResponse response, WebRequest request) {
        return String.valueOf(this.exception(ex, response, request));
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ItemNotFoundException.class})
    @ResponseBody
    public String itemNotFound(Exception e, HttpServletResponse response, WebRequest request) {
        return String.valueOf(this.exception(e, response, request));
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public Object accessDenied(Exception e, WebRequest request) throws Exception {
        String res = ((ServletWebRequest)request).getRequest().getRequestURI();
        return ApiErrorDescription.of(e, res);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={DeleteNotPossibleException.class})
    @ResponseBody
    public String deleteNotPossible(Exception e) {
        return e.getMessage();
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={IllegalIdException.class})
    @ResponseBody
    public String illegalId(Exception e) {
        return e.getMessage();
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={AuthorizationFailedException.class})
    @ResponseBody
    public Object authorizationFailed(Exception e, WebRequest request, HttpServletResponse response) {
        request.setAttribute(REDIRECT_PARAM, (Object)request.getContextPath(), 1);
        return this.exception(e, response, request);
    }

    @ExceptionHandler(value={AuthorizationNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object authorizationNotFound(Exception e, WebRequest request, HttpServletResponse response) {
        String res = ((ServletWebRequest)request).getRequest().getRequestURI();
        response.setStatus(HttpStatus.FORBIDDEN.value());
        return new ObjectMapper().writeValueAsString((Object)ApiErrorDescription.of(e, res));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ItemAlreadyExistsException.class})
    @ResponseBody
    public String itemAlreadyExists(Exception e) {
        return e.getMessage();
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ItemWasDeletedException.class})
    @ResponseBody
    public String itemWasDeleted(Exception e, WebRequest request) {
        String res = ((ServletWebRequest)request).getRequest().getRequestURI();
        if (res.startsWith("/api/v")) {
            return new ObjectMapper().writeValueAsString((Object)ApiErrorDescription.of(e, res));
        }
        return e.toString();
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={HistoryObjectNotFoundException.class})
    @ResponseBody
    public String historyObjectNotFound(Exception e, WebRequest request) {
        String res = ((ServletWebRequest)request).getRequest().getRequestURI();
        if (res.startsWith("/api/v")) {
            return new ObjectMapper().writeValueAsString((Object)ApiErrorDescription.of(e, res));
        }
        return e.toString();
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={EditableObjectNotFoundException.class})
    @ResponseBody
    public String editableObjectNotFound(Exception e, WebRequest request) {
        String res = ((ServletWebRequest)request).getRequest().getRequestURI();
        if (res.startsWith("/api/v")) {
            return new ObjectMapper().writeValueAsString((Object)ApiErrorDescription.of(e, res));
        }
        return e.toString();
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={TranslationException.class})
    @ResponseBody
    public String translationException(Exception e, WebRequest request) {
        String res = ((ServletWebRequest)request).getRequest().getRequestURI();
        if (res.startsWith("/api/v")) {
            return new ObjectMapper().writeValueAsString((Object)ApiErrorDescription.of(e, res));
        }
        return e.toString();
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public String methodArgumentTypeMismatch(Exception e) {
        return e.getMessage();
    }
}

