/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.beans.IdValidator;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.AllowOnPublicSearch;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.SearchException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v1/search/type/"})
@CrossOrigin
public class SearchEntityApi
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(SearchEntityApi.class);
    private static Map<String, SearcherInfo> searchBeans = new HashMap<String, SearcherInfo>();

    public static void registerSearch(String type, SearcherInfo info) {
        searchBeans.putIfAbsent(type, info);
    }

    public SearchEntityApi(WebContext context) {
        super(context);
    }

    public static Class<? extends AbstractService> findServiceByType(String searchName) {
        return searchBeans.get(searchName).getSearchClass();
    }

    @GetMapping(value={"/toString/{type}/{id}"}, produces={"text/plain;charset=UTF-8"})
    @WithRole(ignoreOnCondition=AllowOnPublicSearch.class)
    @ResponseBody
    public ResponseEntity<String> findById(@PathVariable String type, @PathVariable Serializable id) {
        if (this.getBean(IdValidator.class).isIdSet(id)) {
            return ResponseEntity.ok((Object)"search_select");
        }
        AbstractService bean = this.getBean(searchBeans.get(type).getSearchClass());
        Class<? extends AbstractForm> form = bean.getClass().getAnnotation(DataRetrieverDescription.class).form();
        return ResponseEntity.ok((Object)this.getContext().getBean(BeanCopier.class).copy(this.getBean(searchBeans.get(type).getSearchClass()).findById(id).orElseThrow(), form).asValue());
    }

    @GetMapping(value={"{type}"}, produces={"application/json"})
    @WithRole(ignoreOnCondition=AllowOnPublicSearch.class)
    public PageImpl<Map<String, Object>> GET(@PathVariable(value="type") String type, @RequestParam(required=false, value="sub_type") String subType, @RequestParam(value="page", required=false) Integer page, @RequestParam(required=false) Integer limit, @RequestParam(value="s", required=false) String what, @RequestParam(required=false, value="ids") Serializable[] additionalIds) {
        AbstractService bean = this.getBean(searchBeans.get(type).getSearchClass());
        bean.preSearch(what, type);
        if (bean == null) {
            throw new SearchException(type);
        }
        if (page == null || page < 0) {
            page = 0;
        }
        SearcherInfo searchBean = searchBeans.get(type);
        Page res = bean.search(searchBean.getField(), subType, what, page, limit == null ? 10 : limit, additionalIds);
        ArrayList<Map<String, Object>> pageList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < res.getContent().size(); ++i) {
            AbstractEntity model = (AbstractEntity)res.getContent().get(i);
            AbstractForm form = (AbstractForm)this.getBean(BeanCopier.class).copy(model, bean.getForm());
            pageList.add(BeanCopier.values(form, model, this.getContext()));
        }
        return new PageImpl(pageList, res.getPageable(), res.getTotalElements());
    }
}

