/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller;

import java.util.List;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.beans.LocaleBean;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/v1/translation"})
public class TranslationService
extends ApplicationContext {
    private LocaleBean localeBean;

    public TranslationService(WebContext context, LocaleBean localeBean) {
        super(context);
        this.localeBean = localeBean;
    }

    @GetMapping(value={"/{text}/{lang}"})
    public String translate(@PathVariable(value="text") String text, @PathVariable(value="lang") String lang) {
        return this.getContext().getMessageTranslation(text, lang);
    }

    @GetMapping(value={"/cache/clean"})
    @WithRole(value="ROLE_ADMIN")
    public void cleanCache() {
        this.localeBean.clearCache();
    }

    @GetMapping(value={"/list/{lang}"}, produces={"application/json"})
    public List<KeyValue> translations(@PathVariable(value="lang") String lang) {
        return this.localeBean.getMessageTranslations(lang, this.getContext().getWebContext());
    }
}

