/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.forms;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.shared.annotations.AbstractFormModifier;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AbstractAddItemController;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractRepository;
import systems.dennis.shared.service.AbstractService;

public interface Serviceable<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> {
    public static final Logger log = LoggerFactory.getLogger(AbstractAddItemController.class);

    default public <T extends AbstractService<DB_TYPE, ID_TYPE>> T getService() {
        return (T)this.getContext().getBean(this.getServiceClass());
    }

    default public <E extends AbstractEntity> Class<? extends AbstractService> getServiceClass() {
        return this.getClass().getAnnotation(WebFormsSupport.class).value();
    }

    public WebContext.LocalWebContext getContext();

    public static DataRetrieverDescription findDeclaredClass(Class c, DataRetrieverDescription model) {
        if (model == null) {
            final WebFormsSupport ser = c.getAnnotation(WebFormsSupport.class);
            if (ser == null) {
                throw new UnsupportedOperationException("No @FormToModel annotation, no @RepoService annotation on " + String.valueOf(c));
            }
            Class<? extends AbstractService> serviceModel = ser.value();
            model = serviceModel.getAnnotation(DataRetrieverDescription.class);
            if (model == null) {
                throw new UnsupportedOperationException("@FormToModel annotation is not present on " + String.valueOf(c) + " and not present at service : " + String.valueOf(ser.value()));
            }
            if (ser.form() != AbstractForm.class) {
                final DataRetrieverDescription finalModel = model;
                DataRetrieverDescription dataRetrieverDescription = new DataRetrieverDescription(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return finalModel.annotationType();
                    }

                    @Override
                    public Class<? extends AbstractEntity> model() {
                        return finalModel.model();
                    }

                    @Override
                    public Class<? extends AbstractForm> form() {
                        return ser.form();
                    }

                    @Override
                    public Class<? extends AbstractRepository> repo() {
                        return finalModel.repo();
                    }

                    @Override
                    public Class<? extends AbstractFormModifier> formModifier() {
                        return AbstractFormModifier.class;
                    }
                };
            }
        }
        return model;
    }

    default public <T extends AbstractForm> Class<T> getForm() {
        DataRetrieverDescription res = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class));
        return res.form();
    }

    default public <T extends AbstractForm> Class<T> getModel() {
        DataRetrieverDescription res = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class));
        return res.model();
    }

    default public Logger getLog() {
        return log;
    }
}

