/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.forms;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.ValidationFailedException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.ValidationContext;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.validation.ValueValidator;

public interface ValidateForm<FORM extends AbstractForm> {
    default public void validate(KeyValue keyValue) {
        Class<AbstractForm> formClass = this.getClassOfForm();
        Field field = BeanCopier.findField(keyValue.getKey(), formClass);
        HashMap<String, List<ValidationResult>> validationResult = new HashMap<String, List<ValidationResult>>();
        this.validateField(keyValue, field, true, validationResult, keyValue.getValue(), ((Serviceable)((Object)this)).getServiceClass());
        this.checkValidation(validationResult);
    }

    default public void validate(FORM form, boolean edit) {
        this.validate(form, edit, ((Serviceable)((Object)this)).getServiceClass());
    }

    default public void validate(FORM form, boolean edit, Class<? extends AbstractService> serviceable) {
        List<Field> validatedFields = BeanCopier.findAnnotatedFields(form.getClass(), Validation.class);
        HashMap<String, List<ValidationResult>> validationResult = new HashMap<String, List<ValidationResult>>();
        for (Field field : validatedFields) {
            this.validateField(form, field, edit, validationResult, BeanCopier.readValue(form, field), serviceable);
        }
        this.checkValidation(validationResult);
    }

    default public void validateField(Object objectOfForm, Field field, boolean edit, Map<String, List<ValidationResult>> validation, Object valueOfField, Class<? extends AbstractService> serviceClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Validation fieldValidation = field.getAnnotation(Validation.class);
        if (fieldValidation != null) {
            ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
            for (Class<? extends ValueValidator> cl : fieldValidation.value()) {
                ValueValidator validationClass = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                field.setAccessible(true);
                ValidationContent validationContent = new ValidationContent();
                validationContent.setServiceClass(serviceClass);
                validationContent.setField(field.getName());
                validationContent.setValidation(fieldValidation);
                validationContent.setEdit(edit);
                validationContent.setContext(this.getContext());
                ValidationResult validationResult = validationClass.validate(objectOfForm, valueOfField, validationContent);
                validationResults.add(validationResult);
                field.setAccessible(false);
            }
            validation.put(field.getName(), validationResults);
        }
    }

    default public void checkValidation(Map<String, List<ValidationResult>> validationResult) {
        ValidationContext context = new ValidationContext();
        context.setData(validationResult);
        if (!context.getValidationMessages().isEmpty()) {
            throw new ValidationFailedException(context);
        }
    }

    default public Class<? extends AbstractForm> getClassOfForm() {
        return ((Serviceable)((Object)this)).getForm();
    }

    public WebContext.LocalWebContext getContext();
}

