/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.MagicForm;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;

@Secured
public interface AbstractAddItemController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>
extends Serviceable<DB_TYPE, ID_TYPE>,
Transformable<DB_TYPE, FORM>,
MagicForm<FORM> {
    @PostMapping(value={"/add"}, consumes={"application/json", "application/json;charset=UTF-8"}, produces={"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<FORM> add(@RequestBody FORM form) throws ItemForAddContainsIdException {
        this.validate(form, form.getId() != null);
        IDPresenter savedModel = this.getService().save((IDPresenter)((IDPresenter)this.fromForm(form)));
        this.afterSaveForm(form, savedModel);
        return ResponseEntity.ok(this.toForm(savedModel));
    }

    default public void afterSaveForm(FORM form, DB_TYPE model) {
    }
}

