/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.ItemWasDeletedException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.utils.security.DefaultIdChecker;

@Secured
public interface AbstractDeleteItemController<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable>
extends Serviceable<DB_TYPE, ID_TYPE> {
    @WithRole
    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    default public void delete(@Id(checker=DefaultIdChecker.class) @PathVariable ID_TYPE id) throws ItemNotUserException, ItemNotFoundException {
        try {
            this.getService().delete(id);
        }
        catch (ItemNotFoundException | ItemWasDeletedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeleteNotPossibleException();
        }
    }

    @RequestMapping(value={"/delete/deleteItems"}, method={RequestMethod.DELETE})
    default public void deleteItems(@RequestParam List<ID_TYPE> ids) throws ItemNotUserException, ItemNotFoundException {
        for (Serializable id : ids) {
            this.delete(id);
        }
    }
}

