/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.UpdateFieldResponse;
import systems.dennis.shared.controller.items.magic.MagicForm;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.EditFieldException;
import systems.dennis.shared.exceptions.FieldNotFoundException;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Secured
public interface AbstractEditFieldItemController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>
extends Serviceable<DB_TYPE, ID_TYPE>,
Transformable<DB_TYPE, FORM>,
MagicForm<FORM> {
    @WithRole
    @PutMapping(value={"/edit_field/id/{id}"})
    @ResponseBody
    default public ResponseEntity<UpdateFieldResponse<ID_TYPE>> editField(@PathVariable ID_TYPE id, @RequestBody KeyValue keyValue) throws ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException, IllegalAccessException, InvocationTargetException {
        if (keyValue.getKey() == null) {
            throw new EditFieldException(keyValue);
        }
        Field field = BeanCopier.findField(keyValue.getKey(), this.getForm());
        if (field == null) {
            throw new FieldNotFoundException(keyValue.getKey());
        }
        Class<?> type = field.getType();
        Object value = keyValue.getValue();
        if (value == null) {
            KeyValue keyValueFromModel = this.getService().editField(id, keyValue);
            return ResponseEntity.ok(new UpdateFieldResponse<ID_TYPE>(id, keyValueFromModel));
        }
        if (type == Long.class) {
            value = ((Integer)value).longValue();
        }
        this.validate(keyValue);
        KeyValue transformedToModelTypeKeyValue = this.transformValueToModelType(new KeyValue(keyValue.getKey(), value));
        KeyValue keyValueFromModel = this.getService().editField(id, transformedToModelTypeKeyValue);
        KeyValue transformedToFormTypeKeyValue = this.transformValueToFormType(keyValueFromModel);
        UpdateFieldResponse<ID_TYPE> response = new UpdateFieldResponse<ID_TYPE>(id, transformedToFormTypeKeyValue);
        return ResponseEntity.ok(response);
    }
}

