/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;

@Secured
public interface AbstractGetByIdController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>
extends Serviceable<DB_TYPE, ID_TYPE>,
Transformable<DB_TYPE, FORM> {
    @GetMapping(value={"/id/{id}"})
    @ResponseBody
    default public ResponseEntity<FORM> get(@PathVariable(value="id") ID_TYPE id) {
        IDPresenter type = (IDPresenter)this.getService().findById((Serializable)id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        if (type == null) {
            throw ItemNotFoundException.fromId(id);
        }
        return ResponseEntity.ok(this.toForm(type));
    }
}

