/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.importer.Importer;
import systems.dennis.shared.model.IDPresenter;

@Secured
@CrossOrigin
public interface AbstractImportController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm, ID_TYPE extends Serializable>
extends Importer<DB_TYPE, FORM, ID_TYPE>,
Transformable<DB_TYPE, FORM> {
    @PostMapping(value={"/import", "/import/"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<List<FORM>> startImport() throws ItemForAddContainsIdException {
        List res = this.fetchAndStore(this.getContext());
        return ResponseEntity.ok(res);
    }

    @Override
    public WebContext.LocalWebContext getContext();
}

