/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.MagicList;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;

@Secured
public interface AbstractListItemController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>
extends Transformable<DB_TYPE, FORM>,
Serviceable<DB_TYPE, ID_TYPE>,
MagicList<DB_TYPE, ID_TYPE> {
    @GetMapping(value={"/list"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<Map<String, Object>>> get(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        AbstractDataFilter specification = this.getService().getAdditionalSpecification();
        return ResponseEntity.ok(this.toFormPage(this.getService().find(specification, limit, page)));
    }
}

