/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.MagicList;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.form.CountResponse;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.service.AbstractParentalService;

@Secured
public interface AbstractParentalController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>
extends Transformable<DB_TYPE, FORM>,
Serviceable<DB_TYPE, ID_TYPE>,
MagicList<DB_TYPE, ID_TYPE> {
    @GetMapping(value={"/tree/count/parent/{id}"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<CountResponse> countByParent(@PathVariable(value="id") ID_TYPE id) {
        AbstractParentalService bean = (AbstractParentalService)this.getService();
        long count = bean.countByParent(id);
        CountResponse response = new CountResponse();
        response.setCount(count);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/tree/root"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<Map<String, Object>>> findRootElements(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        AbstractParentalService bean = (AbstractParentalService)this.getService();
        Page elements = bean.findRootElements(page, limit);
        return ResponseEntity.ok(this.toFormPage(elements));
    }

    @GetMapping(value={"/tree/parent/{id}"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<Map<String, Object>>> findByParent(@PathVariable(value="id") ID_TYPE id, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        AbstractParentalService bean = (AbstractParentalService)this.getService();
        Page elements = bean.findByParent(id, limit, page);
        return ResponseEntity.ok(this.toFormPage(elements));
    }
}

